/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.extend;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class FileExtension {
    public InputStream stream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public Reader reader(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(stream);
        return new BufferedReader(reader);
    }

    public Reader reader(File file, String charset) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, charset);
        return new BufferedReader(reader);
    }

    public List<String> contains(File file, String pattern) throws IOException {
        FileReader source = new FileReader(file);
        LineNumberReader reader = new LineNumberReader(source);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    ArrayList<String> arrayList = lines;
                    return arrayList;
                }
                if (!line.contains(pattern)) continue;
                lines.add(line);
            }
        }
        finally {
            reader.close();
        }
    }

    public List<String> search(File file, String pattern) throws IOException {
        FileReader source = new FileReader(file);
        LineNumberReader reader = new LineNumberReader(source);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    ArrayList<String> arrayList = lines;
                    return arrayList;
                }
                if (!line.matches(pattern)) continue;
                lines.add(line);
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(File file, byte[] data) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            if (data.length > 0) {
                ((OutputStream)stream).write(data);
            }
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeText(File file, String text) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            byte[] data = text.getBytes();
            if (data.length > 0) {
                ((OutputStream)stream).write(data);
            }
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeText(File file, String text, String encoding) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            byte[] data = text.getBytes(encoding);
            if (data.length > 0) {
                ((OutputStream)stream).write(data);
            }
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int count = 0;
        try {
            while ((count = ((InputStream)stream).read(data)) != -1) {
                buffer.write(data, 0, count);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readText(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int count = 0;
        try {
            while ((count = ((InputStream)stream).read(data)) != -1) {
                buffer.write(data, 0, count);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readText(File file, String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int count = 0;
        try {
            while ((count = ((InputStream)stream).read(data)) != -1) {
                buffer.write(data, 0, count);
            }
            String string = buffer.toString(encoding);
            return string;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public List<String> readLines(File file) throws IOException {
        FileReader reader = new FileReader(file);
        LineNumberReader iterator = new LineNumberReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (true) {
                String line;
                if ((line = iterator.readLine()) == null) {
                    ArrayList<String> arrayList = lines;
                    return arrayList;
                }
                lines.add(line);
            }
        }
        finally {
            iterator.close();
        }
    }

    public List<String> readLines(File file, String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, encoding);
        LineNumberReader iterator = new LineNumberReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (true) {
                String line;
                if ((line = iterator.readLine()) == null) {
                    ArrayList<String> arrayList = lines;
                    return arrayList;
                }
                lines.add(line);
            }
        }
        finally {
            iterator.close();
        }
    }

    public List<File> findFiles(File directory, String pattern) throws IOException {
        File[] list;
        ArrayList<File> files = new ArrayList<File>();
        if (directory.exists() && (list = directory.listFiles()) != null) {
            for (File file : list) {
                List<File> children;
                File normal = file.getCanonicalFile();
                String name = normal.getName();
                if (name.matches(pattern)) {
                    files.add(normal);
                }
                if (!file.isDirectory() || (children = this.findFiles(normal, pattern)).isEmpty()) continue;
                files.addAll(children);
            }
        }
        return files;
    }

    public List<File> findFiles(File directory, FileFilter filter) throws IOException {
        File[] list;
        ArrayList<File> files = new ArrayList<File>();
        if (directory.exists() && (list = directory.listFiles()) != null) {
            for (File file : list) {
                List<File> children;
                File normal = file.getCanonicalFile();
                if (filter.accept(normal)) {
                    files.add(normal);
                }
                if (!file.isDirectory() || (children = this.findFiles(normal, filter)).isEmpty()) continue;
                files.addAll(children);
            }
        }
        return files;
    }

    public List<String> findPaths(File directory, String pattern) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        if (directory.exists()) {
            List<File> files = this.findFiles(directory, pattern);
            for (File file : files) {
                String path = file.getCanonicalPath();
                if (path == null) continue;
                paths.add(path);
            }
        }
        return paths;
    }

    public List<String> findPaths(File directory, FileFilter filter) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        if (directory.exists()) {
            List<File> files = this.findFiles(directory, filter);
            for (File file : files) {
                String path = file.getCanonicalPath();
                if (path == null) continue;
                paths.add(path);
            }
        }
        return paths;
    }
}

