/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.extend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.snapscript.common.Consumer;

public class IteratorExtension {
    public <T> Iterator<T> limit(Iterator<T> iterator, int limit) {
        return new LimitIterator<T>(iterator, limit);
    }

    public <T> Iterator<T> filter(Iterator<T> iterator, Consumer<T, Boolean> filter) {
        return new FilterIterator<T>(iterator, filter);
    }

    public <T> Iterator<T> reverse(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            T value = iterator.next();
            list.add(value);
        }
        if (!list.isEmpty()) {
            Collections.reverse(list);
        }
        return list.iterator();
    }

    public <T> List<T> gather(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            T value = iterator.next();
            list.add(value);
        }
        return list;
    }

    private static class LimitIterator<T>
    implements Iterator<T> {
        private Iterator<T> iterator;
        private int limit;

        public LimitIterator(Iterator<T> iterator, int limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.limit > 0 && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.limit-- > 0) {
                return this.iterator.next();
            }
            return null;
        }
    }

    private static class FilterIterator<T>
    implements Iterator<T> {
        private Consumer<T, Boolean> filter;
        private Iterator<T> iterator;
        private T next;

        public FilterIterator(Iterator<T> iterator, Consumer<T, Boolean> filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (this.iterator.hasNext()) {
                    T value = this.iterator.next();
                    Boolean accept = this.filter.consume(value);
                    if (!Boolean.TRUE.equals(accept)) continue;
                    this.next = value;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T result = this.next;
                this.next = null;
                return result;
            }
            return null;
        }
    }
}

