/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.extend;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Context;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Origin;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.core.type.extend.FunctionExtractor;
import org.snapscript.core.type.extend.ScopeExtension;

public class ModuleExtender {
    private final List<Function> functions = new ArrayList<Function>();
    private final Context context;

    public ModuleExtender(Context context) {
        this.context = context;
    }

    public synchronized void extend(Module module) {
        List<Function> available = module.getFunctions();
        TypeLoader loader = this.context.getLoader();
        if (this.functions.isEmpty()) {
            FunctionExtractor extractor = new FunctionExtractor(loader, Origin.SYSTEM);
            ScopeExtension extension = new ScopeExtension(this.context);
            try {
                List<Function> list = extractor.extract(module, Scope.class, extension);
                for (Function function : list) {
                    this.functions.add(function);
                }
            }
            catch (Exception e) {
                throw new InternalStateException("Could not export runtime", e);
            }
        }
        available.addAll(this.functions);
    }
}

