/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.constraint.AnyConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.type.index.GenericConstraintResolver;

public class ClassHierarchyIndexer {
    private final GenericConstraintResolver resolver = new GenericConstraintResolver();
    private final Constraint any = new AnyConstraint();

    public List<Constraint> index(Class source) throws Exception {
        ArrayList<Constraint> hierarchy = new ArrayList<Constraint>();
        if (source == Object.class) {
            hierarchy.add(this.any);
        } else {
            Type[] interfaces = source.getGenericInterfaces();
            Type base = source.getGenericSuperclass();
            if (base != null) {
                Constraint constraint = this.resolver.resolve(base);
                hierarchy.add(constraint);
            }
            for (Type entry : interfaces) {
                Constraint constraint = this.resolver.resolve(entry);
                hierarchy.add(constraint);
            }
        }
        return hierarchy;
    }
}

