/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationExtractor;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.PrimitivePromoter;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.function.Function;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.extend.ClassExtender;
import org.snapscript.core.type.index.ClassHierarchyIndexer;
import org.snapscript.core.type.index.ClassType;
import org.snapscript.core.type.index.GenericIndexer;
import org.snapscript.core.type.index.MethodIndexer;
import org.snapscript.core.type.index.PropertyIndexer;
import org.snapscript.core.type.index.TypeIndexer;

public class ClassIndexer {
    private final ClassHierarchyIndexer hierarchy;
    private final AnnotationExtractor extractor;
    private final GenericIndexer generics;
    private final MethodIndexer functions;
    private final PropertyIndexer properties;
    private final PrimitivePromoter promoter;
    private final ModuleRegistry registry;
    private final ImportScanner scanner;
    private final TypeIndexer indexer;

    public ClassIndexer(TypeIndexer indexer, ModuleRegistry registry, ImportScanner scanner, ClassExtender extender, PlatformProvider provider) {
        this.properties = new PropertyIndexer(indexer, extender);
        this.functions = new MethodIndexer(extender, provider);
        this.generics = new GenericIndexer(indexer);
        this.hierarchy = new ClassHierarchyIndexer();
        this.extractor = new AnnotationExtractor();
        this.promoter = new PrimitivePromoter();
        this.scanner = scanner;
        this.registry = registry;
        this.indexer = indexer;
    }

    public List<Constraint> indexTypes(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.hierarchy.index(actual);
    }

    public List<Annotation> indexAnnotations(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.extractor.extract(actual);
    }

    public List<Constraint> indexConstraints(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.generics.index(actual);
    }

    public List<Property> indexProperties(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.properties.index(actual);
    }

    public List<Function> indexFunctions(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.functions.index(type);
    }

    public Module indexModule(ClassType type) throws Exception {
        String name;
        Class source = type.getType();
        Class<?> actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        while (actual.isArray()) {
            actual = actual.getComponentType();
        }
        Package module = actual.getPackage();
        if (module != null && (name = this.scanner.importName(module)) != null) {
            return this.registry.addModule(name);
        }
        return this.registry.addModule("default");
    }

    public Type indexOuter(ClassType type) throws Exception {
        Class source = type.getType();
        Class<?> outer = source.getEnclosingClass();
        if (outer != null) {
            Class actual = this.promoter.promote(outer);
            if (actual == null) {
                throw new InternalArgumentException("Could not determine type for " + source);
            }
            return this.indexer.loadType(actual);
        }
        return null;
    }

    public Type indexEntry(ClassType type) throws Exception {
        Class source = type.getType();
        Class<?> entry = source.getComponentType();
        if (entry != null) {
            Class actual = this.promoter.promote(entry);
            if (actual == null) {
                throw new InternalArgumentException("Could not determine type for " + source);
            }
            return this.indexer.loadType(actual);
        }
        return null;
    }

    public int indexModifiers(ClassType type) throws Exception {
        Class source = type.getType();
        int modifiers = source.getModifiers();
        if (source.isEnum()) {
            return ModifierType.ENUM.mask;
        }
        if (source.isInterface()) {
            return ModifierType.TRAIT.mask | ModifierType.ABSTRACT.mask;
        }
        if (source.isArray()) {
            return ModifierType.ARRAY.mask;
        }
        if (Proxy.isProxyClass(source)) {
            return ModifierType.PROXY.mask;
        }
        if (Modifier.isAbstract(modifiers)) {
            return ModifierType.CLASS.mask | ModifierType.ABSTRACT.mask;
        }
        return ModifierType.CLASS.mask;
    }
}

