/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.property.ClassProperty;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.ThisProperty;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.TypeIndexer;

public class ClassPropertyBuilder {
    private final TypeIndexer indexer;

    public ClassPropertyBuilder(TypeIndexer indexer) {
        this.indexer = indexer;
    }

    public List<Property> create(Class source) throws Exception {
        Type type = this.indexer.loadType(source);
        if (type == null) {
            throw new InternalStateException("Could not load type for " + source);
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        ThisProperty thisProperty = new ThisProperty(type);
        ClassProperty classProperty = new ClassProperty(type, Constraint.TYPE);
        properties.add(thisProperty);
        properties.add(classProperty);
        return properties;
    }
}

