/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Constructor;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.ConstructorInvocation;
import org.snapscript.core.type.index.SignatureGenerator;

public class ConstructorGenerator {
    private final SignatureGenerator generator = new SignatureGenerator();
    private final PlatformProvider provider;

    public ConstructorGenerator(PlatformProvider provider) {
        this.provider = provider;
    }

    public Function generate(Type type, Constructor constructor, Class[] types, int modifiers) {
        Platform platform = this.provider.create();
        Signature signature = this.generator.generate(type, constructor);
        Invocation invocation = platform.createConstructor(type, constructor);
        Constraint constraint = Constraint.getConstraint(type);
        try {
            invocation = new ConstructorInvocation(invocation, constructor);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new InvocationFunction(signature, invocation, type, constraint, "new", modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create function for " + constructor, e);
        }
    }
}

