/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.scope.Scope;

public class ConstructorInvocation
implements Invocation<Object> {
    private final Constructor constructor;
    private final Invocation invocation;

    public ConstructorInvocation(Invocation invocation, Constructor constructor) {
        this.constructor = constructor;
        this.invocation = invocation;
    }

    @Override
    public Object invoke(Scope scope, Object left, Object ... list) throws Exception {
        Class<?>[] types;
        int require;
        int start;
        int actual;
        int remaining;
        if (this.constructor.isVarArgs() && (remaining = (actual = list.length) - (start = (require = (types = this.constructor.getParameterTypes()).length) - 1)) >= 0) {
            Class<?> type = types[require - 1];
            Class<?> component = type.getComponentType();
            Object array = Array.newInstance(component, remaining);
            for (int i = 0; i < remaining; ++i) {
                try {
                    Array.set(array, i, list[i + start]);
                    continue;
                }
                catch (Exception e) {
                    throw new InternalStateException("Invalid argument at " + i + " for" + this.constructor, e);
                }
            }
            Object[] copy = new Object[require];
            if (require > list.length) {
                System.arraycopy(list, 0, copy, 0, list.length);
            } else {
                System.arraycopy(list, 0, copy, 0, require);
            }
            copy[start] = array;
            list = copy;
        }
        return this.invocation.invoke(scope, null, list);
    }
}

