/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Accessor;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.TracePointer;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.stack.ThreadStack;

public class FunctionAccessor
implements Accessor {
    private final FunctionPointer pointer;
    private final Function function;
    private final Module module;

    public FunctionAccessor(Function function, ThreadStack stack, Module module) {
        this.pointer = new TracePointer(function, stack);
        this.function = function;
        this.module = module;
    }

    public Object getValue(Object source) {
        Invocation invocation = this.pointer.getInvocation();
        Scope scope = this.module.getScope();
        try {
            if (Scope.class.isInstance(source)) {
                return invocation.invoke((Scope)source, source, new Object[0]);
            }
            return invocation.invoke(scope, source, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalStateException("Error occured invoking '" + this.function + "'", e);
        }
    }

    public void setValue(Object source, Object value) {
        throw new InternalStateException("Illegal modification of '" + this.function + "'");
    }
}

