/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Method;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.DefaultMethodChecker;
import org.snapscript.core.type.index.DefaultMethodInvocation;
import org.snapscript.core.type.index.GenericConstraintExtractor;
import org.snapscript.core.type.index.MethodInvocation;
import org.snapscript.core.type.index.SignatureGenerator;

public class FunctionGenerator {
    private final GenericConstraintExtractor extractor = new GenericConstraintExtractor();
    private final SignatureGenerator generator = new SignatureGenerator();
    private final DefaultMethodChecker checker = new DefaultMethodChecker();
    private final PlatformProvider provider;

    public FunctionGenerator(PlatformProvider provider) {
        this.provider = provider;
    }

    public Function generate(Type type, Method method, String name, int modifiers) {
        Signature signature = this.generator.generate(type, method);
        try {
            Platform platform = this.provider.create();
            Invocation<Object> invocation = platform.createMethod(type, method);
            invocation = this.checker.check(method) ? new DefaultMethodInvocation(method) : new MethodInvocation(invocation, method);
            Constraint constraint = this.extractor.extractReturn(method, modifiers);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return new InvocationFunction(signature, invocation, type, constraint, name, modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create function for " + method, e);
        }
    }
}

