/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.List;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.AccessorProperty;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.module.Module;
import org.snapscript.core.property.Property;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.FunctionAccessor;

public class FunctionPropertyBuilder {
    private static final int MODIFIERS = ModifierType.OVERRIDE.mask | ModifierType.ABSTRACT.mask;

    public Property create(Function function, String name) throws Exception {
        Type type = function.getSource();
        Module module = type.getModule();
        Context context = module.getContext();
        ThreadStack stack = context.getStack();
        Signature signature = function.getSignature();
        List<Parameter> names = signature.getParameters();
        Constraint constraint = function.getConstraint();
        int modifiers = function.getModifiers();
        int count = names.size();
        if (count == 0) {
            FunctionAccessor accessor = new FunctionAccessor(function, stack, module);
            AccessorProperty property = new AccessorProperty(name, type, constraint, accessor, modifiers & ~MODIFIERS);
            return property;
        }
        return null;
    }
}

