/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.index.FunctionPropertyBuilder;
import org.snapscript.core.type.index.PropertyNameExtractor;

public class FunctionPropertyCollector {
    private static final String[] PREFIXES = new String[]{"get", "is"};
    private final FunctionPropertyBuilder builder = new FunctionPropertyBuilder();

    public List<Property> collect(List<Function> functions, Set<String> ignore) throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet<String> done = new HashSet<String>(ignore);
        for (Function function : functions) {
            Property property;
            String name;
            Signature signature = function.getSignature();
            List<Parameter> names = signature.getParameters();
            int count = names.size();
            if (count != 0 || !done.add(name = this.extract(function)) || (property = this.builder.create(function, name)) == null) continue;
            properties.add(property);
        }
        return properties;
    }

    private String extract(Function function) throws Exception {
        String name = function.getName();
        for (String prefix : PREFIXES) {
            String property = PropertyNameExtractor.getProperty(name, prefix);
            if (property == null) continue;
            return property;
        }
        return name;
    }
}

