/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.GenericConstraintResolver;

public class GenericClassConstraint
extends Constraint {
    private GenericConstraintResolver resolver;
    private List<Constraint> generics;
    private Object source;
    private Type type;
    private String name;
    private int modifiers;

    public GenericClassConstraint(GenericConstraintResolver resolver, Object source) {
        this(resolver, source, null);
    }

    public GenericClassConstraint(GenericConstraintResolver resolver, Object source, String name) {
        this(resolver, source, name, 0);
    }

    public GenericClassConstraint(GenericConstraintResolver resolver, Object source, String name, int modifiers) {
        this.modifiers = modifiers;
        this.resolver = resolver;
        this.source = source;
        this.name = name;
    }

    @Override
    public Type getType(Scope scope) {
        if (this.type == null) {
            Constraint constraint = this.resolver.resolve(this.source);
            if (constraint == null) {
                throw new InternalStateException("Could not resolve constraint");
            }
            this.type = constraint.getType(scope);
            this.generics = constraint.getGenerics(scope);
        }
        return this.type;
    }

    @Override
    public List<Constraint> getGenerics(Scope scope) {
        if (this.generics == null) {
            Constraint constraint = this.resolver.resolve(this.source);
            if (constraint == null) {
                throw new InternalStateException("Could not resolve constraint");
            }
            this.type = constraint.getType(scope);
            this.generics = constraint.getGenerics(scope);
        }
        return this.generics;
    }

    @Override
    public String getName(Scope scope) {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return !ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isConstant() {
        return ModifierType.isConstant(this.modifiers);
    }

    @Override
    public boolean isClass() {
        return ModifierType.isClass(this.modifiers);
    }

    public String toString() {
        return String.valueOf(this.type);
    }
}

