/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.type.index.GenericConstraintResolver;

public class GenericConstraintExtractor {
    private final GenericConstraintResolver resolver = new GenericConstraintResolver();

    public Constraint extractField(Field field, int modifiers) {
        Type type = field.getGenericType();
        try {
            return this.resolver.resolve(type, null, modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create constraint for " + field, e);
        }
    }

    public Constraint[] extractGenerics(Method method) {
        Type[] generics = method.getTypeParameters();
        try {
            return this.resolver.resolve(generics);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create constraint for " + method, e);
        }
    }

    public Constraint extractReturn(Method method, int modifiers) {
        Type type = method.getGenericReturnType();
        try {
            return this.resolver.resolve(type, null, modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create constraint for " + method, e);
        }
    }

    public Constraint[] extractParameters(Method method) {
        Type[] parameters = method.getGenericParameterTypes();
        try {
            return this.resolver.resolve(parameters);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create parameter constraints for " + method, e);
        }
    }

    public Constraint[] extractParameters(Constructor constructor) {
        Type[] parameters = constructor.getGenericParameterTypes();
        try {
            return this.resolver.resolve(parameters);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create parameter constraints for " + constructor, e);
        }
    }
}

