/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import org.snapscript.core.constraint.ArrayConstraint;
import org.snapscript.core.constraint.ClassParameterConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.type.index.GenericClassConstraint;
import org.snapscript.core.type.index.GenericConstraintResolver;
import org.snapscript.core.type.index.GenericConverter;

public class GenericConverterResolver {
    private final ParameterizedTypeConverter parameter;
    private final TypeVariableConverter variable;
    private final GenericArrayTypeConverter array;
    private final WildcardTypeConverter wild;
    private final ClassConverter direct;

    public GenericConverterResolver(GenericConstraintResolver resolver) {
        this.parameter = new ParameterizedTypeConverter(resolver);
        this.variable = new TypeVariableConverter(resolver);
        this.array = new GenericArrayTypeConverter(resolver);
        this.wild = new WildcardTypeConverter(resolver);
        this.direct = new ClassConverter();
    }

    public GenericConverter resolve(Type type) {
        if (TypeVariable.class.isInstance(type)) {
            return this.variable;
        }
        if (ParameterizedType.class.isInstance(type)) {
            return this.parameter;
        }
        if (WildcardType.class.isInstance(type)) {
            return this.wild;
        }
        if (GenericArrayType.class.isInstance(type)) {
            return this.array;
        }
        return this.direct;
    }

    private static class TypeVariableConverter
    implements GenericConverter<TypeVariable> {
        private final GenericConstraintResolver resolver;

        public TypeVariableConverter(GenericConstraintResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Constraint convert(TypeVariable variable, String name, int modifiers) {
            Object declaration;
            Type[] bounds = variable.getBounds();
            if (bounds.length > 0 && (Class.class.isInstance(declaration = variable.getGenericDeclaration()) || Method.class.isInstance(declaration))) {
                String key = variable.getName();
                for (int i = 0; i < bounds.length; ++i) {
                    Type bound = bounds[i];
                    if (bound == null) continue;
                    return new GenericClassConstraint(this.resolver, bound, key, modifiers);
                }
            }
            return new ClassParameterConstraint(null, name, modifiers);
        }
    }

    private static class ParameterizedTypeConverter
    implements GenericConverter<ParameterizedType> {
        private final GenericConstraintResolver resolver;

        public ParameterizedTypeConverter(GenericConstraintResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Constraint convert(ParameterizedType type, String name, int modifiers) {
            Type[] arguments = type.getActualTypeArguments();
            Class actual = (Class)type.getRawType();
            if (arguments.length > 0) {
                ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                for (int i = 0; i < arguments.length; ++i) {
                    Type argument = arguments[i];
                    Constraint constraint = this.resolver.resolve(argument);
                    constraints.add(constraint);
                }
                return new ClassParameterConstraint(actual, constraints, name, modifiers);
            }
            return new ClassParameterConstraint(actual, name, modifiers);
        }
    }

    private static class GenericArrayTypeConverter
    implements GenericConverter<GenericArrayType> {
        private final GenericConstraintResolver resolver;

        public GenericArrayTypeConverter(GenericConstraintResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Constraint convert(GenericArrayType type, String name, int modifiers) {
            Type entry = type.getGenericComponentType();
            Constraint constraint = this.resolver.resolve(entry);
            return new ArrayConstraint(constraint, name, 1, modifiers);
        }
    }

    private static class WildcardTypeConverter
    implements GenericConverter<WildcardType> {
        private final GenericConstraintResolver resolver;

        public WildcardTypeConverter(GenericConstraintResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public Constraint convert(WildcardType type, String name, int modifiers) {
            Type[] bounds = type.getUpperBounds();
            if (bounds.length > 0) {
                for (int i = 0; i < bounds.length; ++i) {
                    Type bound = bounds[i];
                    if (bound == null) continue;
                    return new GenericClassConstraint(this.resolver, bound);
                }
            }
            return new ClassParameterConstraint(Object.class, name);
        }
    }

    private static class ClassConverter
    implements GenericConverter<Class> {
        @Override
        public Constraint convert(Class type, String name, int modifiers) {
            return new ClassParameterConstraint(type, name, modifiers);
        }
    }
}

