/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.snapscript.core.Context;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.module.Module;
import org.snapscript.core.platform.Bridge;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.scope.instance.SuperInstance;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.MethodCall;

public class MethodCallBinder {
    private final MethodCall bridge;
    private final MethodCall object;
    private final MethodCall base;

    public MethodCallBinder(Invocation invocation, Method method) {
        this.object = new ObjectCall(invocation, method);
        this.bridge = new BridgeCall(invocation);
        this.base = new SuperCall(method);
    }

    public MethodCall bind(Object target) {
        if (SuperInstance.class.isInstance(target)) {
            return this.base;
        }
        if (Instance.class.isInstance(target)) {
            return this.bridge;
        }
        return this.object;
    }

    private static class SuperCall
    implements MethodCall<SuperInstance> {
        private final Method method;

        public SuperCall(Method method) {
            this.method = method;
        }

        @Override
        public Object call(SuperInstance instance, Object[] arguments) throws Exception {
            String name = this.method.getName();
            Type type = instance.getType();
            Bridge value = instance.getBridge();
            if (value == null) {
                throw new InternalStateException("No 'super' object could be found");
            }
            Module module = instance.getModule();
            Context context = module.getContext();
            PlatformProvider provider = context.getProvider();
            Platform platform = provider.create();
            if (platform == null) {
                throw new InternalStateException("No 'super' method for '" + name + "' found in '" + type + "'");
            }
            Invocation invocation = platform.createSuperMethod(type, this.method);
            Object result = invocation.invoke(instance, value, arguments);
            return result;
        }
    }

    private static class BridgeCall
    implements MethodCall<Instance> {
        private final Invocation invocation;

        public BridgeCall(Invocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object call(Instance instance, Object[] list) throws Exception {
            Bridge value = instance.getBridge();
            if (value == null) {
                throw new InternalStateException("No 'super' object could be found");
            }
            return this.invocation.invoke(instance, value, list);
        }
    }

    private static class ObjectCall
    implements MethodCall {
        private final Invocation invocation;
        private final Method method;

        public ObjectCall(Invocation invocation, Method method) {
            this.invocation = invocation;
            this.method = method;
        }

        public Object call(Object object, Object[] arguments) throws Exception {
            try {
                return this.invocation.invoke(null, object, arguments);
            }
            catch (InvocationTargetException cause) {
                Throwable target = cause.getTargetException();
                String name = this.method.getName();
                if (target != null) {
                    throw new InternalStateException("Error occured invoking '" + name + "'", target);
                }
                throw cause;
            }
        }
    }
}

