/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Method;
import org.snapscript.core.type.index.PropertyNameExtractor;

public enum MethodType {
    GET("get"),
    SET("set"),
    IS("is");

    private final String prefix;
    private final int size;

    private MethodType(String prefix) {
        this.size = prefix.length();
        this.prefix = prefix;
    }

    public boolean isWrite(Method method) {
        String name = method.getName();
        int length = name.length();
        if (name.startsWith(this.prefix)) {
            Class<?> type = method.getReturnType();
            Class<?>[] types = method.getParameterTypes();
            int count = types.length;
            if (type == Void.TYPE) {
                return length > this.size && count == 1;
            }
        }
        return false;
    }

    public boolean isRead(Method method) {
        String name = method.getName();
        int length = name.length();
        if (name.startsWith(this.prefix)) {
            Class<?> type = method.getReturnType();
            Class<?>[] types = method.getParameterTypes();
            int count = types.length;
            if (type != Void.TYPE) {
                return length > this.size && count == 0;
            }
        }
        return false;
    }

    public String getProperty(Method method) {
        String name = method.getName();
        if (name.startsWith(this.prefix)) {
            return PropertyNameExtractor.getProperty(name, this.prefix);
        }
        return name;
    }
}

