/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.snapscript.core.ModifierType;

public class ModifierConverter {
    public int convert(Method method) {
        int result = ModifierType.PROTECTED.mask;
        if (method != null) {
            int modifiers = method.getModifiers();
            if (method.isVarArgs()) {
                result |= ModifierType.VARARGS.mask;
            }
            if (Modifier.isAbstract(modifiers)) {
                result |= ModifierType.ABSTRACT.mask;
            }
            if (Modifier.isFinal(modifiers)) {
                result |= ModifierType.CONSTANT.mask;
            }
            if (Modifier.isPrivate(modifiers)) {
                result |= ModifierType.PRIVATE.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isPublic(modifiers)) {
                result |= ModifierType.PUBLIC.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isStatic(modifiers)) {
                result |= ModifierType.STATIC.mask;
            }
        }
        return result;
    }

    public int convert(Constructor constructor) {
        int result = ModifierType.PROTECTED.mask;
        if (constructor != null) {
            int modifiers = constructor.getModifiers();
            if (constructor.isVarArgs()) {
                result |= ModifierType.VARARGS.mask;
            }
            if (Modifier.isAbstract(modifiers)) {
                result |= ModifierType.ABSTRACT.mask;
            }
            if (Modifier.isFinal(modifiers)) {
                result |= ModifierType.CONSTANT.mask;
            }
            if (Modifier.isPrivate(modifiers)) {
                result |= ModifierType.PRIVATE.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isPublic(modifiers)) {
                result |= ModifierType.PUBLIC.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            result |= ModifierType.STATIC.mask;
        }
        return result;
    }

    public int convert(Field field) {
        int result = ModifierType.PROTECTED.mask;
        if (field != null) {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                result |= ModifierType.CONSTANT.mask;
            }
            if (Modifier.isPrivate(modifiers)) {
                result |= ModifierType.PRIVATE.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isPublic(modifiers)) {
                result |= ModifierType.PUBLIC.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isStatic(modifiers)) {
                result |= ModifierType.STATIC.mask;
            }
        }
        return result;
    }

    public int convert(Class type) {
        int result = ModifierType.PROTECTED.mask;
        if (type != null) {
            int modifiers = type.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                result |= ModifierType.CONSTANT.mask;
            }
            if (Modifier.isPrivate(modifiers)) {
                result |= ModifierType.PRIVATE.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isPublic(modifiers)) {
                result |= ModifierType.PUBLIC.mask;
                result &= ~ModifierType.PROTECTED.mask;
            }
            if (Modifier.isStatic(modifiers)) {
                result |= ModifierType.STATIC.mask;
            }
        }
        return result;
    }
}

