/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.ArrayList;
import java.util.Collections;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.FunctionSignature;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.ParameterBuilder;
import org.snapscript.core.module.Module;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.PrimitiveFunctionAccessor;

public class PrimitiveFunctionGenerator {
    private final PrimitiveFunctionAccessor accessor = new PrimitiveFunctionAccessor();
    private final ParameterBuilder builder = new ParameterBuilder();

    public Function generate(Type type, Constraint returns, String name, Class invoke, Class ... types) {
        Module module = type.getModule();
        Invocation invocation = (Invocation)this.accessor.create(invoke);
        if (invocation == null) {
            throw new InternalStateException("Could not create invocation for " + invoke);
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        FunctionSignature signature = new FunctionSignature(parameters, Collections.EMPTY_LIST, module, null, Origin.DEFAULT, true);
        for (int i = 0; i < types.length; ++i) {
            Class require = types[i];
            Constraint constraint = Constraint.getConstraint(require);
            Parameter parameter = null;
            parameter = require == Object.class ? this.builder.create(Constraint.NONE, i) : this.builder.create(constraint, i);
            parameters.add(parameter);
        }
        if (name.equals("new")) {
            return new InvocationFunction(signature, invocation, type, returns, name, ModifierType.STATIC.mask | ModifierType.PUBLIC.mask);
        }
        return new InvocationFunction(signature, invocation, type, returns, name, ModifierType.PUBLIC.mask);
    }
}

