/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.Progress;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.PrimitiveFunctionGenerator;
import org.snapscript.core.type.index.PrimitiveInstanceBuilder;
import org.snapscript.core.type.index.TypeIndexer;
import org.snapscript.core.variable.Value;

public class PrimitiveIndexer {
    private final AtomicReference<Type> reference;
    private final PrimitiveFunctionGenerator generator = new PrimitiveFunctionGenerator();
    private final TypeIndexer indexer;

    public PrimitiveIndexer(TypeIndexer indexer) {
        this.reference = new AtomicReference();
        this.indexer = indexer;
    }

    public Type indexAny() {
        Type type = this.reference.get();
        if (type == null) {
            Type result = this.indexer.defineType("default", "Any", ModifierType.CLASS.mask);
            Progress<Phase> progress = result.getProgress();
            List<Function> functions = result.getFunctions();
            Function constructor = this.generator.generate(result, Constraint.NONE, "new", NewInvocation.class, Object.class);
            Function hashCode = this.generator.generate(result, Constraint.INTEGER, "hashCode", HashCodeInvocation.class, new Class[0]);
            Function toString = this.generator.generate(result, Constraint.STRING, "toString", ToStringInvocation.class, new Class[0]);
            Function equals = this.generator.generate(result, Constraint.BOOLEAN, "equals", EqualsInvocation.class, Object.class);
            Function wait = this.generator.generate(result, Constraint.NONE, "wait", WaitInvocation.class, new Class[0]);
            Function waitFor = this.generator.generate(result, Constraint.NONE, "wait", WaitForInvocation.class, Long.class);
            Function notify = this.generator.generate(result, Constraint.NONE, "notify", NotifyInvocation.class, new Class[0]);
            Function notifyAll = this.generator.generate(result, Constraint.NONE, "notifyAll", NotifyAllInvocation.class, new Class[0]);
            functions.add(constructor);
            functions.add(wait);
            functions.add(waitFor);
            functions.add(notify);
            functions.add(notifyAll);
            functions.add(hashCode);
            functions.add(equals);
            functions.add(toString);
            progress.done(Phase.COMPILE);
            this.reference.set(type);
            return result;
        }
        return type;
    }

    private static class ToStringInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            return object + "@" + object.hashCode();
        }
    }

    private static class EqualsInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            return object.equals(list[0]);
        }
    }

    private static class HashCodeInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            return object.hashCode();
        }
    }

    private static class NotifyAllInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.notifyAll();
            return null;
        }
    }

    private static class NotifyInvocation
    implements Invocation<Object> {
        public Result invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.notify();
            return null;
        }
    }

    private static class WaitForInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            Number argument = (Number)list[0];
            long time = argument.longValue();
            object.wait(time);
            return null;
        }
    }

    private static class WaitInvocation
    implements Invocation<Object> {
        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            object.wait();
            return null;
        }
    }

    private static class NewInvocation
    implements Invocation<Object> {
        private final PrimitiveInstanceBuilder constructor = new PrimitiveInstanceBuilder();

        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            Type real = (Type)list[0];
            Constraint constraint = Constraint.getConstraint(real);
            Instance instance = this.constructor.create(scope, real);
            State state = instance.getState();
            Value value = Value.getProperty(object, constraint, ModifierType.PUBLIC.mask | ModifierType.CONSTANT.mask);
            state.addValue("this", value);
            return instance;
        }
    }
}

