/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationExtractor;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.Function;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.extend.ClassExtender;
import org.snapscript.core.type.index.ClassPropertyBuilder;
import org.snapscript.core.type.index.FunctionPropertyCollector;
import org.snapscript.core.type.index.GenericConstraintExtractor;
import org.snapscript.core.type.index.MethodMatcher;
import org.snapscript.core.type.index.ModifierConverter;
import org.snapscript.core.type.index.PropertyGenerator;
import org.snapscript.core.type.index.PropertyNameExtractor;
import org.snapscript.core.type.index.TypeIndexer;

public class PropertyIndexer {
    private final GenericConstraintExtractor generics;
    private final FunctionPropertyCollector collector;
    private final AnnotationExtractor extractor;
    private final ClassPropertyBuilder builder;
    private final ModifierConverter converter;
    private final PropertyGenerator generator;
    private final ClassExtender extender;
    private final MethodMatcher matcher;
    private final TypeIndexer indexer;

    public PropertyIndexer(TypeIndexer indexer, ClassExtender extender) {
        this.builder = new ClassPropertyBuilder(indexer);
        this.generics = new GenericConstraintExtractor();
        this.collector = new FunctionPropertyCollector();
        this.extractor = new AnnotationExtractor();
        this.converter = new ModifierConverter();
        this.generator = new PropertyGenerator();
        this.matcher = new MethodMatcher();
        this.extender = extender;
        this.indexer = indexer;
    }

    public List<Property> index(Class source) throws Exception {
        List<Property> properties = this.builder.create(source);
        List<Function> extensions = this.extender.extend(source);
        Method[] methods = source.getDeclaredMethods();
        Field[] fields = source.getDeclaredFields();
        Class[] types = source.getDeclaredClasses();
        Type type = this.indexer.loadType(source);
        int count = extensions.size();
        if (fields.length + methods.length + types.length + count > 0) {
            String name;
            List<Property> indexed;
            HashSet<String> done = new HashSet<String>();
            if (fields.length > 0) {
                indexed = this.index(type, fields);
                for (Property property : indexed) {
                    name = property.getName();
                    if (!done.add(name)) continue;
                    properties.add(property);
                }
            }
            if (methods.length > 0) {
                indexed = this.index(type, methods);
                for (Property property : indexed) {
                    name = property.getName();
                    if (!done.add(name)) continue;
                    properties.add(property);
                }
            }
            if (types.length > 0) {
                indexed = this.index(type, types);
                for (Property property : indexed) {
                    name = property.getName();
                    if (!done.add(name)) continue;
                    properties.add(property);
                }
            }
            if (count > 0) {
                List<Property> extended = this.collector.collect(extensions, done);
                for (Property property : extended) {
                    name = property.getName();
                    if (!done.add(name)) continue;
                    properties.add(property);
                }
            }
        }
        return properties;
    }

    private List<Property> index(Type type, Class[] types) throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Class entry : types) {
            int modifiers = this.converter.convert(entry);
            if (!ModifierType.isPublic(modifiers) && !ModifierType.isProtected(modifiers)) continue;
            String name = entry.getSimpleName();
            Type element = this.indexer.loadType(entry);
            Constraint constraint = Constraint.getConstraint(element, ModifierType.CLASS.mask);
            Property property = this.generator.generate(element, constraint, name, modifiers | ModifierType.CONSTANT.mask);
            List<Annotation> extracted = this.extractor.extract(entry);
            List<Annotation> actual = property.getAnnotations();
            properties.add(property);
            actual.addAll(extracted);
        }
        return properties;
    }

    private List<Property> index(Type type, Field[] fields) throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : fields) {
            int modifiers = this.converter.convert(field);
            if (!ModifierType.isPublic(modifiers) && !ModifierType.isProtected(modifiers)) continue;
            String name = field.getName();
            Constraint constraint = this.generics.extractField(field, modifiers);
            Property property = this.generator.generate(field, type, constraint, name, modifiers);
            List<Annotation> extracted = this.extractor.extract(field);
            List<Annotation> actual = property.getAnnotations();
            properties.add(property);
            actual.addAll(extracted);
        }
        return properties;
    }

    private List<Property> index(Type type, Method[] methods) throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Method method : methods) {
            int modifiers = this.converter.convert(method);
            if (!ModifierType.isPublic(modifiers) || ModifierType.isStatic(modifiers)) continue;
            Class<?>[] parameters = method.getParameterTypes();
            Class<?> returns = method.getReturnType();
            if (parameters.length != 0 || returns == Void.TYPE) continue;
            String name = PropertyNameExtractor.getProperty(method);
            Class<?> declaration = method.getReturnType();
            Method write = this.matcher.match(methods, declaration, name);
            if (write == null) {
                modifiers |= ModifierType.CONSTANT.mask;
            }
            Constraint constraint = this.generics.extractReturn(method, modifiers);
            Property property = this.generator.generate(method, write, type, constraint, name, modifiers);
            List<Annotation> extracted = this.extractor.extract(method);
            List<Annotation> actual = property.getAnnotations();
            if (write != null) {
                write.setAccessible(true);
            }
            method.setAccessible(true);
            properties.add(property);
            actual.addAll(extracted);
        }
        return properties;
    }
}

