/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationConverter;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintMapper;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.FunctionSignature;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.ParameterBuilder;
import org.snapscript.core.function.Signature;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.GenericConstraintExtractor;

public class SignatureGenerator {
    private final GenericConstraintExtractor extractor = new GenericConstraintExtractor();
    private final AnnotationConverter converter = new AnnotationConverter();
    private final ParameterBuilder builder = new ParameterBuilder();
    private final ConstraintMapper mapper = new ConstraintMapper();

    public Signature generate(Type type, Method method) {
        Constraint[] generics = this.extractor.extractGenerics(method);
        Constraint[] parameters = this.extractor.extractParameters(method);
        java.lang.annotation.Annotation[][] annotations = method.getParameterAnnotations();
        Scope scope = type.getScope();
        Module module = type.getModule();
        boolean variable = method.isVarArgs();
        try {
            int i;
            ArrayList<Parameter> signature = new ArrayList<Parameter>();
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            for (i = 0; i < generics.length; ++i) {
                Constraint constraint = generics[i];
                Constraint match = this.mapper.map(scope, constraint);
                constraints.add(match);
            }
            for (i = 0; i < parameters.length; ++i) {
                boolean last = i + 1 == parameters.length;
                Constraint constraint = parameters[i];
                Parameter parameter = this.builder.create(constraint, i, variable && last);
                java.lang.annotation.Annotation[] list = annotations[i];
                if (list.length > 0) {
                    List<Annotation> actual = parameter.getAnnotations();
                    for (int j = 0; j < list.length; ++j) {
                        java.lang.annotation.Annotation value = list[j];
                        Object result = this.converter.convert(value);
                        Annotation annotation = (Annotation)result;
                        actual.add(annotation);
                    }
                }
                signature.add(parameter);
            }
            return new FunctionSignature(signature, constraints, module, method, Origin.PLATFORM, true, variable);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create function for " + method, e);
        }
    }

    public Signature generate(Type type, Constructor constructor) {
        Constraint[] constraints = this.extractor.extractParameters(constructor);
        java.lang.annotation.Annotation[][] annotations = constructor.getParameterAnnotations();
        Module module = type.getModule();
        boolean variable = constructor.isVarArgs();
        try {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < constraints.length; ++i) {
                boolean last = i + 1 == constraints.length;
                Constraint constraint = constraints[i];
                Parameter parameter = this.builder.create(constraint, i, variable && last);
                java.lang.annotation.Annotation[] list = annotations[i];
                if (list.length > 0) {
                    List<Annotation> actual = parameter.getAnnotations();
                    for (int j = 0; j < list.length; ++j) {
                        java.lang.annotation.Annotation value = list[j];
                        Object result = this.converter.convert(value);
                        Annotation annotation = (Annotation)result;
                        actual.add(annotation);
                    }
                }
                parameters.add(parameter);
            }
            return new FunctionSignature(parameters, Collections.EMPTY_LIST, module, constructor, Origin.PLATFORM, true, variable);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create constructor for " + constructor, e);
        }
    }
}

