/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.index;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.common.Cache;
import org.snapscript.common.HashCache;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.extend.ClassExtender;
import org.snapscript.core.type.index.ClassIndexer;
import org.snapscript.core.type.index.ClassType;
import org.snapscript.core.type.index.PrimitiveLoader;
import org.snapscript.core.type.index.ScopeArrayType;
import org.snapscript.core.type.index.ScopeType;

public class TypeIndexer {
    private final Cache<Object, Type> types;
    private final NameFormatter formatter;
    private final ImportScanner scanner;
    private final PrimitiveLoader loader;
    private final ModuleRegistry registry;
    private final ClassIndexer indexer;
    private final AtomicInteger counter;
    private final int limit;

    public TypeIndexer(ModuleRegistry registry, ImportScanner scanner, ClassExtender extender, PlatformProvider provider) {
        this(registry, scanner, extender, provider, 100000);
    }

    public TypeIndexer(ModuleRegistry registry, ImportScanner scanner, ClassExtender extender, PlatformProvider provider, int limit) {
        this.indexer = new ClassIndexer(this, registry, scanner, extender, provider);
        this.types = new HashCache<Object, Type>();
        this.loader = new PrimitiveLoader(this);
        this.formatter = new NameFormatter();
        this.counter = new AtomicInteger(1);
        this.registry = registry;
        this.scanner = scanner;
        this.limit = limit;
    }

    public synchronized Type loadType(String type) {
        Type done = this.types.fetch(type);
        if (done == null) {
            Class match = this.scanner.importType(type);
            if (match == null) {
                return this.loader.loadType(type);
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadType(String module, String name) {
        String alias = this.formatter.formatFullName(module, name);
        Type done = this.types.fetch(alias);
        if (done == null) {
            Class match = this.scanner.importType(alias);
            if (match == null) {
                return this.loader.loadType(alias);
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadArrayType(String module, String name, int size) {
        String alias = this.formatter.formatArrayName(module, name, size);
        Type done = this.types.fetch(alias);
        if (done == null) {
            String type = this.formatter.formatFullName(module, name);
            Class match = this.scanner.importType(type, size);
            if (match == null) {
                if (size > 0) {
                    return this.createArrayType(module, name, size);
                }
                return this.loadType(module, name);
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type defineType(String module, String name, int modifiers) {
        String alias = this.formatter.formatFullName(module, name);
        Type done = this.types.fetch(alias);
        if (done == null) {
            Class match = this.scanner.importType(alias);
            if (match == null) {
                Type type = this.createType(module, name, modifiers);
                this.types.cache(type, type);
                this.types.cache(alias, type);
                return type;
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadType(Class source) {
        Type done = this.types.fetch(source);
        if (done == null) {
            String alias = this.scanner.importName(source);
            String absolute = source.getName();
            Type type = this.createType(source);
            this.types.cache(source, type);
            this.types.cache(alias, type);
            this.types.cache(absolute, type);
            return type;
        }
        return done;
    }

    private synchronized Type createType(String module, String name, int modifiers) {
        String alias = this.formatter.formatFullName(module, name);
        String prefix = this.formatter.formatOuterName(module, name);
        Module parent = this.registry.addModule(module);
        Type type = this.types.fetch(alias);
        if (type == null) {
            Type outer = this.types.fetch(prefix);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ScopeType(parent, outer, name, modifiers, order);
        }
        return type;
    }

    private synchronized Type createArrayType(String module, String name, int size) {
        String alias = this.formatter.formatArrayName(module, name, size);
        Module parent = this.registry.addModule(module);
        Type type = this.types.fetch(alias);
        if (type == null) {
            Type entry = this.loadArrayType(module, name, size - 1);
            if (entry == null) {
                throw new InternalStateException("Type entry for '" + alias + "' not found");
            }
            String array = this.formatter.formatArrayName(null, name, size);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ScopeArrayType(parent, array, entry, size, order);
        }
        return type;
    }

    private synchronized Type createType(Class source) {
        String alias = this.scanner.importName(source);
        Type type = this.types.fetch(alias);
        if (type == null) {
            String name = this.formatter.formatShortName(source);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ClassType(this.indexer, source, name, order);
        }
        return type;
    }
}

