/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.variable.Value;

public class Blank
extends Value {
    private final AtomicReference<Object> reference;
    private final Constraint constraint;
    private final int modifiers;

    public Blank(Object value, Constraint constraint, int modifiers) {
        this.reference = new AtomicReference<Object>(value);
        this.constraint = constraint;
        this.modifiers = modifiers;
    }

    @Override
    public boolean isConstant() {
        return this.reference.get() != null;
    }

    @Override
    public boolean isProperty() {
        return this.modifiers != -1;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public <T> T getValue() {
        return (T)this.reference.get();
    }

    @Override
    public void setValue(Object value) {
        if (!this.reference.compareAndSet(null, value)) {
            throw new InternalStateException("Illegal modification of constant");
        }
    }

    public String toString() {
        return String.valueOf(this.reference);
    }
}

