/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.ClassConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class Constant
extends Value {
    public static final Constraint NUMBER = new ClassConstraint(Number.class, ModifierType.CONSTANT.mask);
    public static final Constraint INTEGER = new ClassConstraint(Integer.class, ModifierType.CONSTANT.mask);
    public static final Constraint LONG = new ClassConstraint(Long.class, ModifierType.CONSTANT.mask);
    public static final Constraint FLOAT = new ClassConstraint(Float.class, ModifierType.CONSTANT.mask);
    public static final Constraint DOUBLE = new ClassConstraint(Double.class, ModifierType.CONSTANT.mask);
    public static final Constraint SHORT = new ClassConstraint(Short.class, ModifierType.CONSTANT.mask);
    public static final Constraint BYTE = new ClassConstraint(Byte.class, ModifierType.CONSTANT.mask);
    public static final Constraint STRING = new ClassConstraint(String.class, ModifierType.CONSTANT.mask);
    public static final Constraint BOOLEAN = new ClassConstraint(Boolean.class, ModifierType.CONSTANT.mask);
    public static final Constraint CHARACTER = new ClassConstraint(Character.class, ModifierType.CONSTANT.mask);
    public static final Constraint LIST = new ClassConstraint(List.class, ModifierType.CONSTANT.mask);
    public static final Constraint TYPE = new ClassConstraint(Type.class, ModifierType.CONSTANT.mask);
    private final Constraint constraint;
    private final Object value;
    private final int modifiers;

    public Constant(Object value) {
        this(value, Constraint.NONE);
    }

    public Constant(Object value, Constraint constraint) {
        this(value, constraint, 0);
    }

    public Constant(Object value, Constraint constraint, int modifiers) {
        this.modifiers = modifiers |= ModifierType.CONSTANT.mask;
        this.constraint = constraint;
        this.value = value;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProperty() {
        return this.modifiers != -1;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public <T> T getValue() {
        return (T)this.value;
    }

    @Override
    public void setValue(Object value) {
        throw new InternalStateException("Illegal modification of constant");
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

