/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.variable.Blank;
import org.snapscript.core.variable.Constant;
import org.snapscript.core.variable.Null;
import org.snapscript.core.variable.Reference;
import org.snapscript.core.variable.Transient;
import org.snapscript.core.variable.ValueMapper;

public abstract class Value {
    public static final Value NULL = new Null();

    public static Value getNull() {
        return new Null();
    }

    public static Value getConstant(Object value) {
        return new Constant(value);
    }

    public static Value getConstant(Object value, Constraint type) {
        return new Constant(value, type);
    }

    public static Value getConstant(Object value, Constraint type, int modifiers) {
        return new Constant(value, type, modifiers);
    }

    public static Value getReference(Object value) {
        return new Reference(value);
    }

    public static Value getReference(Object value, Constraint type) {
        return new Reference(value, type);
    }

    public static Value getProperty(Object value, Constraint type, int modifiers) {
        return new Reference(value, type, modifiers);
    }

    public static Value getBlank(Object value, Constraint type, int modifiers) {
        return new Blank(value, type, modifiers);
    }

    public static Value getTransient(Object value) {
        return new Transient(value);
    }

    public static Value getTransient(Object value, Constraint type) {
        return new Transient(value, type);
    }

    public double getDouble() {
        Number number = this.getNumber();
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public long getLong() {
        Number number = this.getNumber();
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public int getInteger() {
        Number number = this.getNumber();
        if (number != null) {
            return number.intValue();
        }
        return 0;
    }

    public Number getNumber() {
        Object value = this.getValue();
        if (value != null) {
            return ValueMapper.toNumber(value);
        }
        return null;
    }

    public char getCharacter() {
        Object value = this.getValue();
        if (value != null) {
            return ValueMapper.toCharacter(value).charValue();
        }
        return '\u0000';
    }

    public String getString() {
        Object value = this.getValue();
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Class getType() {
        Object value = this.getValue();
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public Constraint getConstraint() {
        return Constraint.NONE;
    }

    public boolean isProperty() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public int getModifiers() {
        return -1;
    }

    public String getName() {
        return null;
    }

    public abstract <T> T getValue();

    public abstract void setValue(Object var1);
}

