/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable;

import org.snapscript.core.variable.Constant;
import org.snapscript.core.variable.Value;

public class ValueCache {
    private static final Value[][] CONSTANTS = new Value[5][2050];
    private static final int HIGH = 1024;
    private static final int LOW = -1024;

    public static Value getByte(int value) {
        if (value >= -1024 && value <= 1024) {
            return CONSTANTS[0][value + 1024];
        }
        return Value.getTransient((byte)value, Constant.BYTE);
    }

    public static Value getShort(int value) {
        if (value >= -1024 && value <= 1024) {
            return CONSTANTS[1][value + 1024];
        }
        return Value.getTransient((short)value, Constant.SHORT);
    }

    public static Value getInteger(int value) {
        if (value >= -1024 && value <= 1024) {
            return CONSTANTS[2][value + 1024];
        }
        return Value.getTransient(value, Constant.INTEGER);
    }

    public static Value getLong(long value) {
        if (value >= -1024L && value <= 1024L) {
            return CONSTANTS[3][(int)value + 1024];
        }
        return Value.getTransient(value, Constant.LONG);
    }

    public static Value getCharacter(char value) {
        if (value >= '\ufffffc00' && value <= '\u0400') {
            return CONSTANTS[4][value + 1024];
        }
        return Value.getTransient(Character.valueOf(value), Constant.CHARACTER);
    }

    public static Value getCharacter(int value) {
        if (value >= -1024 && value <= 1024) {
            return CONSTANTS[4][value + 1024];
        }
        return Value.getTransient(Character.valueOf((char)value), Constant.CHARACTER);
    }

    public static Value getFloat(float value) {
        return Value.getTransient(Float.valueOf(value), Constant.FLOAT);
    }

    public static Value getDouble(double value) {
        return Value.getTransient(value, Constant.DOUBLE);
    }

    static {
        int i = 0;
        int j = -1024;
        while (j <= 1024) {
            ValueCache.CONSTANTS[0][i] = Value.getTransient((byte)j, Constant.BYTE);
            ++j;
            ++i;
        }
        i = 0;
        j = -1024;
        while (j <= 1024) {
            ValueCache.CONSTANTS[1][i] = Value.getTransient((short)j, Constant.SHORT);
            ++j;
            ++i;
        }
        i = 0;
        j = -1024;
        while (j <= 1024) {
            ValueCache.CONSTANTS[2][i] = Value.getTransient(j, Constant.INTEGER);
            ++j;
            ++i;
        }
        i = 0;
        j = -1024;
        while (j <= 1024) {
            ValueCache.CONSTANTS[3][i] = Value.getTransient(j, Constant.LONG);
            ++j;
            ++i;
        }
        i = 0;
        j = -1024;
        while (j <= 1024) {
            ValueCache.CONSTANTS[4][i] = Value.getTransient(Character.valueOf((char)j), Constant.CHARACTER);
            ++j;
            ++i;
        }
    }
}

