/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.bind;

import org.snapscript.core.Entity;
import org.snapscript.core.attribute.AttributeResult;
import org.snapscript.core.attribute.AttributeResultBinder;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyValue;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableResult;

public class PropertyResult
implements VariableResult {
    private final AttributeResultBinder binder;
    private final Property property;
    private final Entity entity;
    private final String name;
    private final Type[] empty;

    public PropertyResult(Property property, Entity entity, String name) {
        this.binder = new AttributeResultBinder(property);
        this.empty = new Type[0];
        this.property = property;
        this.entity = entity;
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Constraint left) {
        Scope scope = this.entity.getScope();
        AttributeResult result = this.binder.bind(scope);
        if (result == null) {
            throw new InternalStateException("No type for '" + this.property + "'");
        }
        try {
            return result.getConstraint(scope, left, this.empty);
        }
        catch (Exception e) {
            throw new InternalStateException("Invalid constraint for '" + this.property + "'", e);
        }
    }

    public Value getValue(Object left) {
        return new PropertyValue(this.property, left, this.name);
    }
}

