/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.bind;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.Context;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleScopeBinder;
import org.snapscript.core.property.Property;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.variable.bind.MapResult;
import org.snapscript.core.variable.bind.ModuleResult;
import org.snapscript.core.variable.bind.PropertyResult;
import org.snapscript.core.variable.bind.TypeResult;
import org.snapscript.core.variable.bind.VariableResult;

public class VariableFinder {
    private final ModuleScopeBinder binder = new ModuleScopeBinder();
    private final ProxyWrapper wrapper;

    public VariableFinder(ProxyWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public VariableResult findAll(Scope scope, Object left, String name) {
        VariableResult match;
        Class<?> type = left.getClass();
        Module module = scope.getModule();
        Type source = module.getType(type);
        if (source != null && (match = this.findAll(scope, source, name)) != null) {
            return match;
        }
        return null;
    }

    public VariableResult findAll(Scope scope, Type type, String name) {
        VariableResult match = this.findProperty(scope, type, name);
        if (match == null) {
            return this.findConstant(scope, type, name);
        }
        return match;
    }

    public VariableResult findAll(Scope scope, Module left, String name) {
        List<Property> properties = left.getProperties();
        for (Property property : properties) {
            String field = property.getName();
            if (!field.equals(name)) continue;
            return new PropertyResult(property, left, name);
        }
        return this.findAll(scope, (Object)left, name);
    }

    public VariableResult findProperty(Scope scope, Object left, String name) {
        VariableResult match;
        Class<?> type = left.getClass();
        Module module = scope.getModule();
        Type source = module.getType(type);
        if (source != null && (match = this.findProperty(scope, source, name)) != null) {
            return match;
        }
        return null;
    }

    public VariableResult findProperty(Scope scope, Type type, String name) {
        Module module = scope.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Set<Type> list = extractor.getTypes(type);
        for (Type base : list) {
            List<Property> properties = base.getProperties();
            for (Property property : properties) {
                String field = property.getName();
                if (!field.equals(name)) continue;
                return new PropertyResult(property, base, name);
            }
        }
        return null;
    }

    public VariableResult findProperty(Scope scope, Map left, String name) {
        VariableResult property = this.findProperty(scope, (Object)left, name);
        if (property == null) {
            return new MapResult(this.wrapper, Constraint.NONE, name);
        }
        return property;
    }

    public VariableResult findConstant(Scope scope, Type type, String name) {
        Module module = scope.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Set<Type> list = extractor.getTypes(type);
        for (Type base : list) {
            Scope outer = base.getScope();
            VariableResult result = this.findType(outer, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public VariableResult findType(Scope scope, String name) {
        Type parent;
        Scope current = this.binder.bind(scope);
        Module module = current.getModule();
        VariableResult result = this.findType(scope, module, name);
        if (result == null && (parent = current.getType()) != null) {
            return this.findType(scope, parent, name);
        }
        return result;
    }

    public VariableResult findType(Scope scope, Module module, String name) {
        Type inner = module.getType(name);
        if (inner == null) {
            Module result = module.getModule(name);
            if (result != null) {
                return new ModuleResult(result);
            }
            return null;
        }
        return new TypeResult(inner);
    }

    public VariableResult findType(Scope scope, Type type, String name) {
        Module module = type.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Type inner = extractor.getType(type, name);
        if (inner != null) {
            return new TypeResult(inner);
        }
        return null;
    }
}

