/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.lang.reflect.Array;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.index.TypeInstancePointer;
import org.snapscript.core.variable.index.VariablePointer;

public class ArrayPointer
implements VariablePointer<Object> {
    private final TypeInstancePointer pointer;
    private final String name;

    public ArrayPointer(VariableFinder finder, String name) {
        this.pointer = new TypeInstancePointer(finder, name);
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        if (this.name.equals("length")) {
            return Constraint.INTEGER;
        }
        if (this.name.equals("class")) {
            return Constraint.TYPE;
        }
        return this.pointer.getConstraint(scope, left);
    }

    @Override
    public Value getValue(Scope scope, Object left) {
        if (this.name.equals("length")) {
            int length = Array.getLength(left);
            return Value.getConstant(length);
        }
        return this.pointer.getValue(scope, left);
    }
}

