/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.Collection;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.index.TypeInstancePointer;
import org.snapscript.core.variable.index.VariablePointer;

public class CollectionPointer
implements VariablePointer<Collection> {
    private final TypeInstancePointer pointer;
    private final String name;

    public CollectionPointer(VariableFinder finder, String name) {
        this.pointer = new TypeInstancePointer(finder, name);
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        if (this.name.equals("length")) {
            return Constraint.INTEGER;
        }
        return this.pointer.getConstraint(scope, left);
    }

    @Override
    public Value getValue(Scope scope, Collection left) {
        if (this.name.equals("length")) {
            int length = left.size();
            return Value.getConstant(length);
        }
        return this.pointer.getValue(scope, left);
    }
}

