/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.bind.VariableResult;
import org.snapscript.core.variable.index.VariablePointer;

public class LocalPointer
implements VariablePointer<Object> {
    private final AtomicReference<VariableResult> reference = new AtomicReference();
    private final VariableFinder finder;
    private final String name;

    public LocalPointer(VariableFinder finder, String name) {
        this.finder = finder;
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            State state = scope.getState();
            Value variable = state.getValue(this.name);
            if (variable == null) {
                VariableResult match = this.finder.findType(scope, this.name);
                if (match != null) {
                    return match.getConstraint(left);
                }
                return null;
            }
            return variable.getConstraint();
        }
        return result.getConstraint(left);
    }

    @Override
    public Value getValue(Scope scope, Object left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            VariableResult match;
            State state = scope.getState();
            Value variable = state.getValue(this.name);
            if (variable == null && (match = this.finder.findType(scope, this.name)) != null) {
                this.reference.set(match);
                return match.getValue(left);
            }
            return variable;
        }
        return result.getValue(left);
    }
}

