/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.bind.VariableResult;
import org.snapscript.core.variable.index.VariablePointer;

public class MapPointer
implements VariablePointer<Map> {
    private final AtomicReference<VariableResult> reference = new AtomicReference();
    private final VariableFinder finder;
    private final String name;

    public MapPointer(VariableFinder finder, String name) {
        this.finder = finder;
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            Type type = left.getType(scope);
            VariableResult match = this.finder.findProperty(scope, type, this.name);
            if (match != null) {
                this.reference.set(match);
                return match.getConstraint(left);
            }
            return Constraint.NONE;
        }
        return result.getConstraint(left);
    }

    @Override
    public Value getValue(Scope scope, Map left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            VariableResult match = this.finder.findProperty(scope, left, this.name);
            if (match != null) {
                this.reference.set(match);
                return match.getValue(left);
            }
            return null;
        }
        return result.getValue(left);
    }
}

