/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.bind.VariableResult;
import org.snapscript.core.variable.index.VariablePointer;

public class ModulePointer
implements VariablePointer<Module> {
    private final AtomicReference<VariableResult> reference = new AtomicReference();
    private final VariableFinder finder;
    private final String name;

    public ModulePointer(VariableFinder finder, String name) {
        this.finder = finder;
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            Type parent = left.getType(scope);
            Module module = parent.getModule();
            State state = scope.getState();
            Value value = state.getValue(this.name);
            if (value == null) {
                Type type = module.getType(this.name);
                if (type == null) {
                    VariableResult match = this.finder.findAll(scope, module, this.name);
                    if (match != null) {
                        this.reference.set(match);
                        return match.getConstraint(left);
                    }
                    return null;
                }
                return Constraint.getConstraint(type, ModifierType.CONSTANT.mask);
            }
            return value.getConstraint();
        }
        return result.getConstraint(left);
    }

    @Override
    public Value getValue(Scope scope, Module left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            Scope inner = left.getScope();
            State state = inner.getState();
            Value value = state.getValue(this.name);
            if (value == null) {
                Type type = left.getType(this.name);
                if (type == null) {
                    VariableResult match = this.finder.findAll(scope, left, this.name);
                    if (match != null) {
                        this.reference.set(match);
                        return match.getValue(left);
                    }
                    return null;
                }
                return Value.getTransient(type);
            }
            return value;
        }
        return result.getValue(left);
    }
}

