/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.variable.Value;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.bind.VariableResult;
import org.snapscript.core.variable.index.VariablePointer;

public class TypeInstancePointer
implements VariablePointer<Object> {
    private final AtomicReference<VariableResult> reference = new AtomicReference();
    private final VariableFinder finder;
    private final String name;

    public TypeInstancePointer(VariableFinder finder, String name) {
        this.finder = finder;
        this.name = name;
    }

    @Override
    public Constraint getConstraint(Scope scope, Constraint left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            VariableResult match;
            Type type = left.getType(scope);
            if (type != null && (match = this.finder.findAll(scope, type, this.name)) != null) {
                this.reference.set(match);
                return match.getConstraint(left);
            }
            return null;
        }
        return result.getConstraint(left);
    }

    @Override
    public Value getValue(Scope scope, Object left) {
        VariableResult result = this.reference.get();
        if (result == null) {
            Module module = scope.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Type type = extractor.getType(left);
            VariableResult match = this.finder.findAll(scope, type, this.name);
            if (match != null) {
                this.reference.set(match);
                return match.getValue(left);
            }
            return null;
        }
        return result.getValue(left);
    }
}

