/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.index.EmptyPointer;
import org.snapscript.core.variable.index.VariableIndexResolver;
import org.snapscript.core.variable.index.VariablePointer;
import org.snapscript.core.variable.index.VariablePointerBuilder;

public class VariableIndexer {
    private final AtomicReference<VariablePointer> reference;
    private final Cache<Integer, VariablePointer> cache = new CopyOnWriteCache<Integer, VariablePointer>();
    private final VariablePointerBuilder builder;
    private final VariableIndexResolver resolver;
    private final VariablePointer empty;

    public VariableIndexer(ProxyWrapper wrapper, String name) {
        this.reference = new AtomicReference();
        this.builder = new VariablePointerBuilder(wrapper, name);
        this.resolver = new VariableIndexResolver();
        this.empty = new EmptyPointer();
    }

    public VariablePointer index(Scope scope) throws Exception {
        VariablePointer pointer = this.reference.get();
        if (pointer == null) {
            pointer = this.builder.create(scope);
            this.reference.set(pointer);
        }
        return pointer;
    }

    public VariablePointer index(Scope scope, Object left) throws Exception {
        int index = this.resolver.resolve(scope, left);
        VariablePointer pointer = this.cache.fetch(index);
        if (pointer == null) {
            pointer = this.builder.create(scope, left);
            this.cache.cache(index, pointer);
        }
        return pointer;
    }

    public VariablePointer index(Scope scope, Constraint left) throws Exception {
        Type type = left.getType(scope);
        if (type != null) {
            return this.builder.create(scope, left);
        }
        return this.empty;
    }
}

