/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.variable.index;

import java.util.Collection;
import java.util.Map;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.function.Function;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.bind.VariableFinder;
import org.snapscript.core.variable.index.ArrayPointer;
import org.snapscript.core.variable.index.ClosurePointer;
import org.snapscript.core.variable.index.CollectionPointer;
import org.snapscript.core.variable.index.LocalPointer;
import org.snapscript.core.variable.index.MapPointer;
import org.snapscript.core.variable.index.ModulePointer;
import org.snapscript.core.variable.index.TypeInstancePointer;
import org.snapscript.core.variable.index.TypeLocalPointer;
import org.snapscript.core.variable.index.TypeStaticPointer;
import org.snapscript.core.variable.index.VariablePointer;

public class VariablePointerBuilder {
    private final VariableFinder finder;
    private final String name;

    public VariablePointerBuilder(ProxyWrapper wrapper, String name) {
        this.finder = new VariableFinder(wrapper);
        this.name = name;
    }

    public VariablePointer create(Scope scope) throws Exception {
        if (Instance.class.isInstance(scope)) {
            return new TypeLocalPointer(this.finder, this.name);
        }
        return new LocalPointer(this.finder, this.name);
    }

    public VariablePointer create(Scope scope, Object left) throws Exception {
        Class<?> type = left.getClass();
        if (Module.class.isInstance(left)) {
            return new ModulePointer(this.finder, this.name);
        }
        if (Map.class.isInstance(left)) {
            return new MapPointer(this.finder, this.name);
        }
        if (Type.class.isInstance(left)) {
            return new TypeStaticPointer(this.finder, this.name);
        }
        if (Collection.class.isInstance(left)) {
            return new CollectionPointer(this.finder, this.name);
        }
        if (Function.class.isInstance(left)) {
            return new ClosurePointer(this.finder, this.name);
        }
        if (type.isArray()) {
            return new ArrayPointer(this.finder, this.name);
        }
        return new TypeInstancePointer(this.finder, this.name);
    }

    public VariablePointer create(Scope scope, Constraint left) throws Exception {
        Type type = left.getType(scope);
        if (type != null) {
            Class real = type.getType();
            int modifiers = type.getModifiers();
            if (left.isModule()) {
                return new ModulePointer(this.finder, this.name);
            }
            if (left.isClass()) {
                return new TypeStaticPointer(this.finder, this.name);
            }
            if (ModifierType.isFunction(modifiers)) {
                return new ClosurePointer(this.finder, this.name);
            }
            if (ModifierType.isArray(modifiers)) {
                return new ArrayPointer(this.finder, this.name);
            }
            if (real != null) {
                if (Map.class.isAssignableFrom(real)) {
                    return new MapPointer(this.finder, this.name);
                }
                if (Collection.class.isAssignableFrom(real)) {
                    return new CollectionPointer(this.finder, this.name);
                }
            }
        }
        return new TypeInstancePointer(this.finder, this.name);
    }
}

