/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.yield;

import java.util.Iterator;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.yield.NoResume;
import org.snapscript.core.yield.Resume;

public class Yield
implements Iterable<Object> {
    private final Resume next;
    private final Object result;
    private final Scope scope;

    public Yield(Object result) {
        this(result, null, null);
    }

    public Yield(Object result, Scope scope, Resume next) {
        this.result = result;
        this.scope = scope;
        this.next = next;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ResumeIterator(this.result, this.scope, this.next);
    }

    public Resume getResume() {
        if (this.next == null) {
            return new NoResume();
        }
        return this.next;
    }

    public <T> T getValue() {
        return (T)this.result;
    }

    private static class ResumeIterator
    implements Iterator {
        private Resume resume;
        private Object value;
        private Scope scope;

        public ResumeIterator(Object value, Scope scope, Resume resume) {
            this.resume = resume;
            this.value = value;
            this.scope = scope;
        }

        @Override
        public boolean hasNext() {
            if (this.value == null && this.resume != null) {
                try {
                    Result result = this.resume.resume(this.scope, null);
                    if (result.isYield()) {
                        Yield yield = (Yield)result.getValue();
                        this.resume = yield.getResume();
                        this.value = yield.getValue();
                        return true;
                    }
                }
                catch (Throwable e) {
                    throw new InternalStateException("Could not resume after yield", e);
                }
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                Object result = this.value;
                this.value = null;
                return result;
            }
            return null;
        }
    }
}

