/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.dex.file;

import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.dex.DexIndexOverflowException;
import org.snapscript.dx.dex.file.DexFile;
import org.snapscript.dx.dex.file.Item;
import org.snapscript.dx.dex.file.MemberIdItem;
import org.snapscript.dx.dex.file.MethodIdsSection;
import org.snapscript.dx.dex.file.UniformItemSection;

public abstract class MemberIdsSection
extends UniformItemSection {
    public MemberIdsSection(String name, DexFile file) {
        super(name, file, 4);
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        if (this.items().size() > 65536) {
            throw new DexIndexOverflowException(this.getTooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(idx);
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTooManyMembersMessage() {
        TreeMap<String, AtomicInteger> membersByPackage = new TreeMap<String, AtomicInteger>();
        for (Item item : this.items()) {
            String packageName = ((MemberIdItem)item).getDefiningClass().getPackageName();
            AtomicInteger count = (AtomicInteger)membersByPackage.get(packageName);
            if (count == null) {
                count = new AtomicInteger();
                membersByPackage.put(packageName, count);
            }
            count.incrementAndGet();
        }
        Formatter formatter = new Formatter();
        try {
            String string = this instanceof MethodIdsSection ? "method" : "field";
            formatter.format("Too many %s references: %d; max is %d.%nThe list of classes given is too big and does not fit in the main dex.%nReferences by package:", string, this.items().size(), 65536);
            for (Map.Entry entry : membersByPackage.entrySet()) {
                formatter.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
            }
            String string2 = formatter.toString();
            return string2;
        }
        finally {
            formatter.close();
        }
    }
}

