/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.dex.file;

import org.snapscript.dx.dex.file.DexFile;
import org.snapscript.dx.dex.file.ItemType;
import org.snapscript.dx.dex.file.OffsettedItem;
import org.snapscript.dx.dex.file.TypeIdsSection;
import org.snapscript.dx.rop.type.StdTypeList;
import org.snapscript.dx.rop.type.Type;
import org.snapscript.dx.rop.type.TypeList;
import org.snapscript.dx.util.AnnotatedOutput;
import org.snapscript.dx.util.Hex;

public final class TypeListItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int ELEMENT_SIZE = 2;
    private static final int HEADER_SIZE = 4;
    private final TypeList list;

    public TypeListItem(TypeList list) {
        super(4, list.size() * 2 + 4);
        this.list = list;
    }

    public int hashCode() {
        return StdTypeList.hashContents(this.list);
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_TYPE_LIST;
    }

    @Override
    public void addContents(DexFile file) {
        TypeIdsSection typeIds = file.getTypeIds();
        int sz = this.list.size();
        for (int i = 0; i < sz; ++i) {
            typeIds.intern(this.list.getType(i));
        }
    }

    @Override
    public String toHuman() {
        throw new RuntimeException("unsupported");
    }

    public TypeList getList() {
        return this.list;
    }

    @Override
    protected void writeTo0(DexFile file, AnnotatedOutput out) {
        int i;
        TypeIdsSection typeIds = file.getTypeIds();
        int sz = this.list.size();
        if (out.annotates()) {
            out.annotate(0, this.offsetString() + " type_list");
            out.annotate(4, "  size: " + Hex.u4(sz));
            for (i = 0; i < sz; ++i) {
                Type one = this.list.getType(i);
                int idx = typeIds.indexOf(one);
                out.annotate(2, "  " + Hex.u2(idx) + " // " + one.toHuman());
            }
        }
        out.writeInt(sz);
        for (i = 0; i < sz; ++i) {
            out.writeShort(typeIds.indexOf(this.list.getType(i)));
        }
    }

    @Override
    protected int compareTo0(OffsettedItem other) {
        TypeList thisList = this.list;
        TypeList otherList = ((TypeListItem)other).list;
        return StdTypeList.compareContents(thisList, otherList);
    }
}

