/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.dex.file;

import java.util.Collection;
import org.snapscript.dx.dex.file.DexFile;
import org.snapscript.dx.dex.file.IndexedItem;
import org.snapscript.dx.dex.file.Item;
import org.snapscript.dx.dex.file.Section;
import org.snapscript.dx.rop.cst.Constant;
import org.snapscript.dx.util.AnnotatedOutput;

public abstract class UniformItemSection
extends Section {
    public UniformItemSection(String name, DexFile file, int alignment) {
        super(name, file, alignment);
    }

    @Override
    public final int writeSize() {
        Collection<? extends Item> items = this.items();
        int sz = items.size();
        if (sz == 0) {
            return 0;
        }
        return sz * items.iterator().next().writeSize();
    }

    public abstract IndexedItem get(Constant var1);

    @Override
    protected final void prepare0() {
        DexFile file = this.getFile();
        this.orderItems();
        for (Item item : this.items()) {
            item.addContents(file);
        }
    }

    @Override
    protected final void writeTo0(AnnotatedOutput out) {
        DexFile file = this.getFile();
        int alignment = this.getAlignment();
        for (Item item : this.items()) {
            item.writeTo(file, out);
            out.alignTo(alignment);
        }
    }

    @Override
    public final int getAbsoluteItemOffset(Item item) {
        IndexedItem ii = (IndexedItem)item;
        int relativeOffset = ii.getIndex() * ii.writeSize();
        return this.getAbsoluteOffset(relativeOffset);
    }

    protected abstract void orderItems();
}

