/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.stock;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.snapscript.dx.Code;
import org.snapscript.dx.DexMaker;
import org.snapscript.dx.Local;
import org.snapscript.dx.MethodId;
import org.snapscript.dx.TypeId;
import org.snapscript.dx.stock.ProxyAdapter;
import org.snapscript.dx.stock.ProxyBuilder;

public final class ProxyAdapterBuilder<T> {
    public static final int VERSION = 1;
    private static final Map<Class<?>, Class<?>> generatedAccessorClasses = Collections.synchronizedMap(new HashMap());
    private final Class<T> baseClass;
    private ClassLoader parentClassLoader = ProxyBuilder.class.getClassLoader();
    private File dexCache;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_BOXED = new HashMap();
    private static final Map<TypeId<?>, MethodId<?, ?>> PRIMITIVE_TYPE_TO_UNBOX_METHOD;
    private static final Map<Class<?>, MethodId<?, ?>> PRIMITIVE_TO_UNBOX_METHOD;

    private ProxyAdapterBuilder(Class<T> clazz) {
        this.baseClass = clazz;
    }

    public static <T> ProxyAdapterBuilder<T> forClass(Class<T> clazz) {
        return new ProxyAdapterBuilder<T>(clazz);
    }

    public ProxyAdapterBuilder<T> parentClassLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
        return this;
    }

    public ProxyAdapterBuilder<T> dexCache(File dexCacheParent) {
        this.dexCache = new File(dexCacheParent, "v" + Integer.toString(1));
        this.dexCache.mkdir();
        return this;
    }

    public Class buildAccessor(Method method) throws Exception {
        Method accessibleMethod = ProxyAdapterBuilder.getAccessibleMethod(method);
        if (accessibleMethod != null) {
            Class<Object> accessorClass = generatedAccessorClasses.get(accessibleMethod);
            if (accessorClass == null) {
                DexMaker dexMaker = new DexMaker();
                String generatedName = ProxyAdapterBuilder.getNameForAccessorOf(accessibleMethod);
                TypeId generatedType = TypeId.get("L" + generatedName + ";");
                TypeId<ProxyAdapter> interfaceType = TypeId.get(ProxyAdapter.class);
                ProxyAdapterBuilder.generateConstructorsForAccessor(dexMaker, generatedType, TypeId.OBJECT);
                ProxyAdapterBuilder.generateCodeForAccessor(dexMaker, generatedType, accessibleMethod);
                dexMaker.declare(generatedType, generatedName + ".generated", 17, TypeId.OBJECT, interfaceType);
                ClassLoader classLoader = dexMaker.generateAndLoad(this.parentClassLoader, this.dexCache, generatedName);
                try {
                    accessorClass = this.loadClass(classLoader, generatedName);
                }
                catch (IllegalAccessError e) {
                    throw new UnsupportedOperationException("cannot proxy inaccessible class " + this.baseClass, e);
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return accessorClass;
        }
        return null;
    }

    public Class buildAccessor(Constructor constructor) throws Exception {
        Constructor accessibleConstructor = ProxyAdapterBuilder.getAccessibleConstructor(constructor);
        if (accessibleConstructor != null) {
            Class<Object> accessorClass = generatedAccessorClasses.get(accessibleConstructor);
            if (accessorClass == null) {
                DexMaker dexMaker = new DexMaker();
                String generatedName = ProxyAdapterBuilder.getNameForAccessorOf(accessibleConstructor);
                TypeId generatedType = TypeId.get("L" + generatedName + ";");
                TypeId<ProxyAdapter> interfaceType = TypeId.get(ProxyAdapter.class);
                ProxyAdapterBuilder.generateConstructorsForAccessor(dexMaker, generatedType, TypeId.OBJECT);
                ProxyAdapterBuilder.generateCodeForAccessor(dexMaker, generatedType, accessibleConstructor);
                dexMaker.declare(generatedType, generatedName + ".generated", 17, TypeId.OBJECT, interfaceType);
                ClassLoader classLoader = dexMaker.generateAndLoad(this.parentClassLoader, this.dexCache, generatedName);
                try {
                    accessorClass = this.loadClass(classLoader, generatedName);
                }
                catch (IllegalAccessError e) {
                    throw new UnsupportedOperationException("cannot proxy inaccessible class " + this.baseClass, e);
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return accessorClass;
        }
        return null;
    }

    private Class<? extends T> loadClass(ClassLoader classLoader, String generatedName) throws ClassNotFoundException {
        return classLoader.loadClass(generatedName);
    }

    private static <T, G extends T> void generateCodeForAccessor(DexMaker dexMaker, TypeId<G> generatedType, Method accessorMethod) {
        int p;
        int modifiers = accessorMethod.getModifiers();
        String name = accessorMethod.getName();
        Class<?> declaringClass = accessorMethod.getDeclaringClass();
        Class<?>[] argClasses = accessorMethod.getParameterTypes();
        Class<?> returnClass = accessorMethod.getReturnType();
        TypeId<Object[]> objectArrayType = TypeId.get(Object[].class);
        TypeId<Object> objectType = TypeId.get(Object.class);
        TypeId<?> instanceType = TypeId.get(declaringClass);
        TypeId[] argTypes = new TypeId[argClasses.length];
        Local[] argumentHolders = new Local[argTypes.length];
        Local[] boxedParameterHolder = new Local[argTypes.length];
        Local[] realParameterHolders = new Local[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = TypeId.get(argClasses[i]);
        }
        TypeId<?> returnType = TypeId.get(returnClass);
        MethodId<G, Object> methodToGenerate = generatedType.getMethod(objectType, "invoke", objectType, objectArrayType);
        MethodId<?, ?> methodToInvoke = instanceType.getMethod(returnType, name, argTypes);
        Code code = dexMaker.declare(methodToGenerate, 17);
        Local<Object> temp = code.newLocal(TypeId.OBJECT);
        Local<Object> targetObject = code.getParameter(0, TypeId.OBJECT);
        Local<Object[]> argumentArray = code.getParameter(1, objectArrayType);
        Local<Integer> intValue = code.newLocal(TypeId.INT);
        Local<Object> returnValue = code.newLocal(TypeId.OBJECT);
        Local<?> resultHolder = null;
        Local<?> instanceHolder = null;
        if (returnClass != Void.TYPE) {
            resultHolder = code.newLocal(returnType);
        }
        if (!Modifier.isStatic(modifiers)) {
            instanceHolder = code.newLocal(instanceType);
        }
        for (p = 0; p < argTypes.length; ++p) {
            argumentHolders[p] = code.newLocal(objectType);
            Class<?> boxedType = PRIMITIVE_TO_BOXED.get(argClasses[p]);
            if (boxedType != null) {
                boxedParameterHolder[p] = code.newLocal(TypeId.get(boxedType));
                realParameterHolders[p] = code.newLocal(argTypes[p]);
                continue;
            }
            boxedParameterHolder[p] = code.newLocal(argTypes[p]);
            realParameterHolders[p] = boxedParameterHolder[p];
        }
        for (p = 0; p < argTypes.length; ++p) {
            code.loadConstant(intValue, p);
            code.aget(argumentHolders[p], argumentArray, intValue);
            if (PRIMITIVE_TO_UNBOX_METHOD.containsKey(argClasses[p])) {
                code.cast(boxedParameterHolder[p], argumentHolders[p]);
                MethodId<?, ?> unboxingMethodFor = ProxyAdapterBuilder.getUnboxMethodForPrimitive(argClasses[p]);
                code.invokeVirtual(unboxingMethodFor, realParameterHolders[p], boxedParameterHolder[p], new Local[0]);
                continue;
            }
            code.cast(realParameterHolders[p], argumentHolders[p]);
        }
        if (Modifier.isStatic(modifiers)) {
            code.invokeStatic(methodToInvoke, resultHolder, realParameterHolders);
        } else if (declaringClass.isInterface()) {
            code.cast(instanceHolder, targetObject);
            code.invokeInterface(methodToInvoke, resultHolder, instanceHolder, realParameterHolders);
        } else {
            code.cast(instanceHolder, targetObject);
            code.invokeVirtual(methodToInvoke, resultHolder, instanceHolder, realParameterHolders);
        }
        if (returnClass != Void.TYPE) {
            Local<?> boxedIfNecessary = ProxyAdapterBuilder.boxIfRequired(code, resultHolder, temp);
            code.cast(returnValue, boxedIfNecessary);
        } else {
            code.loadConstant(returnValue, null);
        }
        code.returnValue(returnValue);
    }

    private static <T, G extends T> void generateCodeForAccessor(DexMaker dexMaker, TypeId<G> generatedType, Constructor accessorConstructor) {
        int p;
        Class declaringClass = accessorConstructor.getDeclaringClass();
        Class<?>[] argClasses = accessorConstructor.getParameterTypes();
        Class returnClass = declaringClass;
        TypeId<Object[]> objectArrayType = TypeId.get(Object[].class);
        TypeId<Object> objectType = TypeId.get(Object.class);
        TypeId instanceType = TypeId.get(declaringClass);
        TypeId[] argTypes = new TypeId[argClasses.length];
        Local[] argumentHolders = new Local[argTypes.length];
        Local[] boxedParameterHolder = new Local[argTypes.length];
        Local[] realParameterHolders = new Local[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = TypeId.get(argClasses[i]);
        }
        TypeId returnType = TypeId.get(returnClass);
        MethodId<G, Object> methodToGenerate = generatedType.getMethod(objectType, "invoke", objectType, objectArrayType);
        MethodId constructorToInvoke = instanceType.getConstructor(argTypes);
        Code code = dexMaker.declare(methodToGenerate, 1);
        Local<Object[]> argumentArray = code.getParameter(1, objectArrayType);
        Local<Integer> intValue = code.newLocal(TypeId.INT);
        Local<Object> returnValue = code.newLocal(TypeId.OBJECT);
        Local resultHolder = code.newLocal(returnType);
        for (p = 0; p < argTypes.length; ++p) {
            argumentHolders[p] = code.newLocal(objectType);
            Class<?> boxedType = PRIMITIVE_TO_BOXED.get(argClasses[p]);
            if (boxedType != null) {
                boxedParameterHolder[p] = code.newLocal(TypeId.get(boxedType));
                realParameterHolders[p] = code.newLocal(argTypes[p]);
                continue;
            }
            boxedParameterHolder[p] = code.newLocal(argTypes[p]);
            realParameterHolders[p] = boxedParameterHolder[p];
        }
        for (p = 0; p < argTypes.length; ++p) {
            code.loadConstant(intValue, p);
            code.aget(argumentHolders[p], argumentArray, intValue);
            if (PRIMITIVE_TO_UNBOX_METHOD.containsKey(argClasses[p])) {
                code.cast(boxedParameterHolder[p], argumentHolders[p]);
                MethodId<?, ?> unboxingMethodFor = ProxyAdapterBuilder.getUnboxMethodForPrimitive(argClasses[p]);
                code.invokeVirtual(unboxingMethodFor, realParameterHolders[p], boxedParameterHolder[p], new Local[0]);
                continue;
            }
            code.cast(realParameterHolders[p], argumentHolders[p]);
        }
        code.newInstance(resultHolder, constructorToInvoke, realParameterHolders);
        code.cast(returnValue, resultHolder);
        code.returnValue(returnValue);
    }

    private static Local<?> boxIfRequired(Code code, Local<?> parameter, Local<Object> temp) {
        MethodId<?, ?> unboxMethod = PRIMITIVE_TYPE_TO_UNBOX_METHOD.get(parameter.getType());
        if (unboxMethod == null) {
            return parameter;
        }
        code.invokeStatic(unboxMethod, temp, parameter);
        return temp;
    }

    private static <T, G extends T> void generateConstructorsForAccessor(DexMaker dexMaker, TypeId<G> generatedType, TypeId<T> superType) {
        MethodId<G, Void> method = generatedType.getConstructor(new TypeId[0]);
        Code constructorCode = dexMaker.declare(method, 1);
        Local<G> thisRef = constructorCode.getThis(generatedType);
        constructorCode.invokeDirect(TypeId.OBJECT.getConstructor(new TypeId[0]), null, thisRef, new Local[0]);
        constructorCode.returnVoid();
    }

    private static <T> String getNameForAccessorOf(Method method) {
        try {
            String name = method.getName();
            String type = method.getDeclaringClass().getSimpleName();
            String source = method.toString();
            byte[] data = source.getBytes();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] octets = digest.digest(data);
            StringBuilder builder = new StringBuilder();
            builder.append(type);
            builder.append("_");
            builder.append(name);
            builder.append("_");
            for (int i = 0; i < octets.length; ++i) {
                int value = (octets[i] & 0xFF) + 256;
                String code = Integer.toString(value, 16);
                String token = code.substring(1);
                builder.append(token);
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate name for " + method, e);
        }
    }

    private static <T> String getNameForAccessorOf(Constructor constructor) {
        try {
            String type = constructor.getDeclaringClass().getSimpleName();
            String source = constructor.toString();
            byte[] data = source.getBytes();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] octets = digest.digest(data);
            StringBuilder builder = new StringBuilder();
            builder.append(type);
            builder.append("_new_");
            for (int i = 0; i < octets.length; ++i) {
                int value = (octets[i] & 0xFF) + 256;
                String code = Integer.toString(value, 16);
                String token = code.substring(1);
                builder.append(token);
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate name for " + constructor, e);
        }
    }

    private static Constructor getAccessibleConstructor(Constructor constructor) {
        Class type = constructor.getDeclaringClass();
        int typeModifiers = type.getModifiers();
        int constructorModifiers = type.getModifiers();
        if (!Modifier.isPublic(constructorModifiers) || !Modifier.isPublic(typeModifiers)) {
            return null;
        }
        return constructor;
    }

    private static Method getAccessibleMethod(Method method) {
        Class<?> type;
        Class[] methodParameters = method.getParameterTypes();
        String methodName = method.getName();
        int typeModifiers = type.getModifiers();
        int methodModifiers = type.getModifiers();
        if (!Modifier.isPublic(methodModifiers)) {
            return null;
        }
        if (!Modifier.isPublic(typeModifiers)) {
            for (type = method.getDeclaringClass(); type != null; type = type.getSuperclass()) {
                Class<?>[] interfaceTypes = type.getInterfaces();
                for (int i = 0; i < interfaceTypes.length; ++i) {
                    Class<?> interfaceType = interfaceTypes[i];
                    int interfaceModifiers = interfaceType.getModifiers();
                    if (!Modifier.isPublic(interfaceModifiers)) continue;
                    Method[] interfaceMethods = interfaceType.getDeclaredMethods();
                    for (int j = 0; j < interfaceMethods.length; ++j) {
                        Method interfaceMethod = interfaceMethods[j];
                        Class[] interfaceParameters = interfaceMethod.getParameterTypes();
                        String interfaceMethodName = interfaceMethod.getName();
                        if (interfaceParameters.length != methodParameters.length || !methodName.equals(interfaceMethodName) || !ProxyAdapterBuilder.isTypeArrayEqual(interfaceParameters, methodParameters)) continue;
                        return interfaceMethod;
                    }
                }
            }
            return null;
        }
        return method;
    }

    private static boolean isTypeArrayEqual(Class[] interfaceParameters, Class[] methodParameters) {
        if (interfaceParameters.length != methodParameters.length) {
            return false;
        }
        for (int i = 0; i < interfaceParameters.length; ++i) {
            Class interfaceParameter = interfaceParameters[i];
            Class methodParameter = methodParameters[i];
            if (interfaceParameter == methodParameter) continue;
            return false;
        }
        return true;
    }

    private static MethodId<?, ?> getUnboxMethodForPrimitive(Class<?> methodReturnType) {
        return PRIMITIVE_TO_UNBOX_METHOD.get(methodReturnType);
    }

    static {
        PRIMITIVE_TO_BOXED.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_BOXED.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_BOXED.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_BOXED.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOXED.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_BOXED.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_BOXED.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_BOXED.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_TO_UNBOX_METHOD = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_TO_BOXED.entrySet()) {
            TypeId<?> primitiveType = TypeId.get(entry.getKey());
            TypeId<?> boxedType = TypeId.get(entry.getValue());
            MethodId<?, ?> valueOfMethod = boxedType.getMethod(boxedType, "valueOf", primitiveType);
            PRIMITIVE_TYPE_TO_UNBOX_METHOD.put(primitiveType, valueOfMethod);
        }
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, TypeId.get(Boolean.class).getMethod(TypeId.BOOLEAN, "booleanValue", new TypeId[0]));
        map.put(Integer.TYPE, TypeId.get(Integer.class).getMethod(TypeId.INT, "intValue", new TypeId[0]));
        map.put(Byte.TYPE, TypeId.get(Byte.class).getMethod(TypeId.BYTE, "byteValue", new TypeId[0]));
        map.put(Long.TYPE, TypeId.get(Long.class).getMethod(TypeId.LONG, "longValue", new TypeId[0]));
        map.put(Short.TYPE, TypeId.get(Short.class).getMethod(TypeId.SHORT, "shortValue", new TypeId[0]));
        map.put(Float.TYPE, TypeId.get(Float.class).getMethod(TypeId.FLOAT, "floatValue", new TypeId[0]));
        map.put(Double.TYPE, TypeId.get(Double.class).getMethod(TypeId.DOUBLE, "doubleValue", new TypeId[0]));
        map.put(Character.TYPE, TypeId.get(Character.class).getMethod(TypeId.CHAR, "charValue", new TypeId[0]));
        PRIMITIVE_TO_UNBOX_METHOD = map;
    }
}

