/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.stock;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.dx.Code;
import org.snapscript.dx.Comparison;
import org.snapscript.dx.DexMaker;
import org.snapscript.dx.FieldId;
import org.snapscript.dx.Label;
import org.snapscript.dx.Local;
import org.snapscript.dx.MethodId;
import org.snapscript.dx.TypeId;

public final class ProxyBuilder<T> {
    public static final int VERSION = 1;
    private static final String FIELD_NAME_HANDLER = "$__handler";
    private static final String FIELD_NAME_METHODS = "$__methodArray";
    private static final Map<Class<?>, Class<?>> generatedProxyClasses = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, ClassLoader> generatedProxyClassesClassLoaders = Collections.synchronizedMap(new HashMap());
    private final Class<T> baseClass;
    private ClassLoader parentClassLoader = ProxyBuilder.class.getClassLoader();
    private InvocationHandler handler;
    private File dexCache;
    private Class<?>[] constructorArgTypes = new Class[0];
    private Object[] constructorArgValues = new Object[0];
    private Set<Class<?>> interfaces = new HashSet();
    private Set<Class<?>> beanInterfaces = new HashSet();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_BOXED = new HashMap();
    private static final Map<TypeId<?>, MethodId<?, ?>> PRIMITIVE_TYPE_TO_UNBOX_METHOD;
    private static final Map<Class<?>, MethodId<?, ?>> PRIMITIVE_TO_UNBOX_METHOD;

    private ProxyBuilder(Class<T> clazz) {
        this.baseClass = clazz;
    }

    public static <T> ProxyBuilder<T> forClass(Class<T> clazz) {
        return new ProxyBuilder<T>(clazz);
    }

    public ProxyBuilder<T> parentClassLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
        return this;
    }

    public ProxyBuilder<T> handler(InvocationHandler handler) {
        this.handler = handler;
        return this;
    }

    public ProxyBuilder<T> dexCache(File dexCacheParent) {
        this.dexCache = new File(dexCacheParent, "v" + Integer.toString(1));
        this.dexCache.mkdir();
        return this;
    }

    public ProxyBuilder<T> implementingBeans(Class<?> ... beanInterfaces) {
        for (Class<?> i : beanInterfaces) {
            if (!i.isInterface()) {
                throw new IllegalArgumentException("Not an interface: " + i.getName());
            }
            this.beanInterfaces.add(i);
        }
        return this;
    }

    public ProxyBuilder<T> implementing(Class<?> ... interfaces) {
        for (Class<?> i : interfaces) {
            if (!i.isInterface()) {
                throw new IllegalArgumentException("Not an interface: " + i.getName());
            }
            this.interfaces.add(i);
        }
        return this;
    }

    public ProxyBuilder<T> constructorArgValues(Object ... constructorArgValues) {
        this.constructorArgValues = constructorArgValues;
        return this;
    }

    public ProxyBuilder<T> constructorArgTypes(Class<?> ... constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes;
        return this;
    }

    public T build() throws IOException {
        T result;
        Constructor<T> constructor;
        ProxyBuilder.check(this.handler != null, "handler == null");
        ProxyBuilder.check(this.constructorArgTypes.length == this.constructorArgValues.length, "constructorArgValues.length != constructorArgTypes.length");
        Class<T> proxyClass = this.buildProxyClass();
        try {
            constructor = proxyClass.getConstructor(this.constructorArgTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor for " + this.baseClass.getName() + " with parameter types " + Arrays.toString(this.constructorArgTypes));
        }
        try {
            result = constructor.newInstance(this.constructorArgValues);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw ProxyBuilder.launderCause(e);
        }
        return result;
    }

    public Class<? extends T> buildProxyClass() throws IOException {
        Class bridgeClass;
        Class<?> proxyClass = generatedProxyClasses.get(this.baseClass);
        Set<Class<?>> interfaces = this.determineImplementInterfaces();
        if (proxyClass != null && proxyClass.getClassLoader().getParent() == this.parentClassLoader && interfaces.equals(ProxyBuilder.asSet(proxyClass.getInterfaces()))) {
            return proxyClass;
        }
        ClassLoader cacheClassLoader = generatedProxyClassesClassLoaders.get(bridgeClass = this.buildBridgeClass(this.baseClass));
        return this.buildProxyClass(bridgeClass, cacheClassLoader == null ? this.parentClassLoader : cacheClassLoader);
    }

    private Class<? extends T> buildProxyClass(Class baseClass, ClassLoader parentClassLoader) throws IOException {
        DexMaker dexMaker = new DexMaker();
        Class<T> proxyClass = null;
        String generatedName = ProxyBuilder.getNameForProxyOf(baseClass);
        TypeId generatedType = TypeId.get("L" + generatedName + ";");
        TypeId superType = TypeId.get(baseClass);
        ProxyBuilder.generateConstructorsAndFields(dexMaker, generatedType, superType, baseClass);
        Method[] methodsToProxy = this.getMethodsToProxyRecursive(this.interfaces);
        ProxyBuilder.generateCodeForAllMethods(dexMaker, generatedType, methodsToProxy, superType);
        dexMaker.declare(generatedType, generatedName + ".generated", 1, superType, this.getInterfacesAsTypeIds(this.interfaces));
        ClassLoader classLoader = dexMaker.generateAndLoad(parentClassLoader, this.dexCache, generatedName);
        try {
            proxyClass = this.loadClass(classLoader, generatedName);
        }
        catch (IllegalAccessError e) {
            throw new UnsupportedOperationException("cannot proxy inaccessible class " + baseClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        ProxyBuilder.setInvocationHandler(proxyClass, this.handler);
        ProxyBuilder.setMethodsStaticField(proxyClass, methodsToProxy);
        generatedProxyClasses.put(baseClass, proxyClass);
        generatedProxyClassesClassLoaders.put(proxyClass, classLoader);
        return proxyClass;
    }

    private Class buildBridgeClass(Class baseClass) throws IOException {
        DexMaker dexMaker = new DexMaker();
        Class<T> bridgeClass = null;
        String generatedName = ProxyBuilder.getNameForBridgeOf(baseClass);
        TypeId generatedType = TypeId.get("L" + generatedName + ";");
        TypeId superType = TypeId.get(baseClass);
        ProxyBuilder.generateConstructorsForBridge(dexMaker, generatedType, superType, baseClass);
        Method[] abstractMethods = this.getAbstractMethodsToProxyRecursive();
        BeanProperty[] beanMethods = this.getBeanMethodsToProxyRecursive();
        ProxyBuilder.generateCodeForAbstractMethods(dexMaker, abstractMethods, generatedType);
        ProxyBuilder.generateCodeForBeanMethods(dexMaker, beanMethods, generatedType);
        dexMaker.declare(generatedType, generatedName + ".generated", 1, superType, this.getInterfacesAsTypeIds(this.beanInterfaces));
        ClassLoader classLoader = dexMaker.generateAndLoad(this.parentClassLoader, this.dexCache, generatedName);
        try {
            bridgeClass = this.loadClass(classLoader, generatedName);
        }
        catch (IllegalAccessError e) {
            throw new UnsupportedOperationException("cannot proxy inaccessible class " + baseClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        generatedProxyClassesClassLoaders.put(bridgeClass, classLoader);
        return bridgeClass;
    }

    private Class<? extends T> loadClass(ClassLoader classLoader, String generatedName) throws ClassNotFoundException {
        return classLoader.loadClass(generatedName);
    }

    private static RuntimeException launderCause(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new UndeclaredThrowableException(cause);
    }

    private static void setMethodsStaticField(Class<?> proxyClass, Method[] methodsToProxy) {
        try {
            Field methodArrayField = proxyClass.getDeclaredField(FIELD_NAME_METHODS);
            methodArrayField.setAccessible(true);
            methodArrayField.set(null, methodsToProxy);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InvocationHandler getInvocationHandler(Class<?> proxyClass) {
        try {
            Field field = proxyClass.getDeclaredField(FIELD_NAME_HANDLER);
            field.setAccessible(true);
            return (InvocationHandler)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Not a valid proxy instance", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setInvocationHandler(Class<?> proxyClass, InvocationHandler handler) {
        try {
            Field handlerField = proxyClass.getDeclaredField(FIELD_NAME_HANDLER);
            handlerField.setAccessible(true);
            handlerField.set(null, handler);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Not a valid proxy class", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isProxyClass(Class<?> c) {
        try {
            c.getDeclaredField(FIELD_NAME_HANDLER);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private static <T, G extends T> void generateCodeForAbstractMethods(DexMaker dexMaker, Method[] methodsToImplement, TypeId<G> generatedType) {
        for (int m = 0; m < methodsToImplement.length; ++m) {
            Method method = methodsToImplement[m];
            String name = method.getName();
            Class<?>[] argClasses = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            TypeId[] argTypes = new TypeId[argClasses.length];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = TypeId.get(argClasses[i]);
            }
            TypeId<?> resultType = TypeId.get(returnType);
            MethodId<G, ?> implementMethod = generatedType.getMethod(resultType, name, argTypes);
            Code code = dexMaker.declare(implementMethod, 1);
            TypeId<UnsupportedOperationException> iseType = TypeId.get(UnsupportedOperationException.class);
            MethodId<UnsupportedOperationException, Void> iseConstructor = iseType.getConstructor(new TypeId[0]);
            Local<UnsupportedOperationException> localIse = code.newLocal(iseType);
            code.newInstance(localIse, iseConstructor, new Local[0]);
            code.throwValue(localIse);
        }
    }

    private static <T, G extends T> void generateCodeForBeanMethods(DexMaker dexMaker, BeanProperty[] methodsToImplement, TypeId<G> generatedType) {
        for (int m = 0; m < methodsToImplement.length; ++m) {
            BeanProperty method = methodsToImplement[m];
            String name = method.getName();
            Class type = method.getType();
            Method setter = method.getSetter();
            Method getter = method.getGetter();
            TypeId propertyType = TypeId.get(type);
            FieldId propertyField = generatedType.getField(propertyType, "$__" + name);
            dexMaker.declare(propertyField, 1, null);
            ProxyBuilder.generateGetterMethod(dexMaker, getter, name, propertyField, generatedType);
            ProxyBuilder.generateSetterMethod(dexMaker, setter, name, propertyField, generatedType);
        }
    }

    private static <G, V> void generateGetterMethod(DexMaker dexMaker, Method method, String property, FieldId propertyField, TypeId<G> generatedType) {
        String name = method.getName();
        Class<?>[] argClasses = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        TypeId[] argTypes = new TypeId[argClasses.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = TypeId.get(argClasses[i]);
        }
        TypeId<?> resultType = TypeId.get(returnType);
        MethodId<G, ?> implementMethod = generatedType.getMethod(resultType, name, argTypes);
        Code code = dexMaker.declare(implementMethod, 1);
        Local<G> localThis = code.getThis(generatedType);
        Local<?> localValue = code.newLocal(resultType);
        code.iget(propertyField, localValue, localThis);
        code.returnValue(localValue);
    }

    private static <G> void generateSetterMethod(DexMaker dexMaker, Method method, String property, FieldId propertyField, TypeId<G> generatedType) {
        String name = method.getName();
        Class<?>[] argClasses = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        TypeId[] argTypes = new TypeId[argClasses.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = TypeId.get(argClasses[i]);
        }
        TypeId<?> resultType = TypeId.get(returnType);
        MethodId<G, ?> implementMethod = generatedType.getMethod(resultType, name, argTypes);
        Code code = dexMaker.declare(implementMethod, 1);
        Local<G> localThis = code.getThis(generatedType);
        Local parameter = code.getParameter(0, argTypes[0]);
        code.iput(propertyField, localThis, parameter);
        code.returnVoid();
    }

    private static <T, G extends T> void generateCodeForAllMethods(DexMaker dexMaker, TypeId<G> generatedType, Method[] methodsToProxy, TypeId<T> superclassType) {
        TypeId<InvocationHandler> handlerType = TypeId.get(InvocationHandler.class);
        TypeId<Method[]> methodArrayType = TypeId.get(Method[].class);
        FieldId<G, InvocationHandler> handlerField = generatedType.getField(handlerType, FIELD_NAME_HANDLER);
        FieldId<G, Method[]> allMethods = generatedType.getField(methodArrayType, FIELD_NAME_METHODS);
        TypeId<Method> methodType = TypeId.get(Method.class);
        TypeId<Object[]> objectArrayType = TypeId.get(Object[].class);
        MethodId<InvocationHandler, Object> methodInvoke = handlerType.getMethod(TypeId.OBJECT, "invoke", TypeId.OBJECT, methodType, objectArrayType);
        for (int m = 0; m < methodsToProxy.length; ++m) {
            Method method = methodsToProxy[m];
            String name = method.getName();
            Class<?>[] argClasses = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            TypeId[] argTypes = new TypeId[argClasses.length];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = TypeId.get(argClasses[i]);
            }
            TypeId<?> resultType = TypeId.get(returnType);
            MethodId<T, ?> superMethod = superclassType.getMethod(resultType, name, argTypes);
            MethodId<G, ?> methodId = generatedType.getMethod(resultType, name, argTypes);
            Code code = dexMaker.declare(methodId, 1);
            Local<G> localThis = code.getThis(generatedType);
            Local<InvocationHandler> localHandler = code.newLocal(handlerType);
            Local<Object> invokeResult = code.newLocal(TypeId.OBJECT);
            Local<Integer> intValue = code.newLocal(TypeId.INT);
            Local<Object[]> args = code.newLocal(objectArrayType);
            Local<Integer> argsLength = code.newLocal(TypeId.INT);
            Local<Object> temp = code.newLocal(TypeId.OBJECT);
            Local<?> resultHolder = code.newLocal(resultType);
            Local<Method[]> methodArray = code.newLocal(methodArrayType);
            Local<Method> thisMethod = code.newLocal(methodType);
            Local<Integer> methodIndex = code.newLocal(TypeId.INT);
            Class<?> aBoxedClass = PRIMITIVE_TO_BOXED.get(returnType);
            Local<?> aBoxedResult = null;
            if (aBoxedClass != null) {
                aBoxedResult = code.newLocal(TypeId.get(aBoxedClass));
            }
            Local[] superArgs2 = new Local[argClasses.length];
            Local<?> superResult2 = code.newLocal(resultType);
            Local<InvocationHandler> nullHandler = code.newLocal(handlerType);
            code.loadConstant(methodIndex, m);
            code.sget(allMethods, methodArray);
            code.aget(thisMethod, methodArray, methodIndex);
            code.loadConstant(argsLength, argTypes.length);
            code.newArray(args, argsLength);
            code.sget(handlerField, localHandler);
            code.loadConstant(nullHandler, null);
            Label handlerNullCase = new Label();
            code.compare(Comparison.EQ, handlerNullCase, nullHandler, localHandler);
            for (int p = 0; p < argTypes.length; ++p) {
                code.loadConstant(intValue, p);
                Local parameter = code.getParameter(p, argTypes[p]);
                Local unboxedIfNecessary = ProxyBuilder.boxIfRequired(code, parameter, temp);
                code.aput(args, intValue, unboxedIfNecessary);
            }
            code.invokeInterface(methodInvoke, invokeResult, localHandler, localThis, thisMethod, args);
            ProxyBuilder.generateCodeForReturnStatement(code, returnType, invokeResult, resultHolder, aBoxedResult);
            code.mark(handlerNullCase);
            for (int i = 0; i < superArgs2.length; ++i) {
                superArgs2[i] = code.getParameter(i, argTypes[i]);
            }
            if (Void.TYPE.equals(returnType)) {
                code.invokeSuper(superMethod, null, localThis, superArgs2);
                code.returnVoid();
            } else {
                ProxyBuilder.invokeSuper(superMethod, code, localThis, superArgs2, superResult2);
                code.returnValue(superResult2);
            }
            MethodId<G, ?> callsSuperMethod = generatedType.getMethod(resultType, ProxyBuilder.superMethodName(method), argTypes);
            Code superCode = dexMaker.declare(callsSuperMethod, 1);
            Local<G> superThis = superCode.getThis(generatedType);
            Local[] superArgs = new Local[argClasses.length];
            for (int i = 0; i < superArgs.length; ++i) {
                superArgs[i] = superCode.getParameter(i, argTypes[i]);
            }
            if (Void.TYPE.equals(returnType)) {
                superCode.invokeSuper(superMethod, null, superThis, superArgs);
                superCode.returnVoid();
                continue;
            }
            Local<?> superResult = superCode.newLocal(resultType);
            ProxyBuilder.invokeSuper(superMethod, superCode, superThis, superArgs, superResult);
            superCode.returnValue(superResult);
        }
    }

    private static void invokeSuper(MethodId superMethod, Code superCode, Local superThis, Local[] superArgs, Local superResult) {
        superCode.invokeSuper(superMethod, superResult, superThis, superArgs);
    }

    private static Local<?> boxIfRequired(Code code, Local<?> parameter, Local<Object> temp) {
        MethodId<?, ?> unboxMethod = PRIMITIVE_TYPE_TO_UNBOX_METHOD.get(parameter.getType());
        if (unboxMethod == null) {
            return parameter;
        }
        code.invokeStatic(unboxMethod, temp, parameter);
        return temp;
    }

    public static Object callSuper(Object proxy, Method method, Object ... args) throws Throwable {
        try {
            return proxy.getClass().getMethod(ProxyBuilder.superMethodName(method), method.getParameterTypes()).invoke(proxy, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static String superMethodName(Method method) {
        String returnType = method.getReturnType().getName();
        return "super$" + method.getName() + "$" + returnType.replace('.', '_').replace('[', '_').replace(';', '_');
    }

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private static <T, G extends T> void generateConstructorsAndFields(DexMaker dexMaker, TypeId<G> generatedType, TypeId<T> superType, Class<T> superClass) {
        TypeId<InvocationHandler> handlerType = TypeId.get(InvocationHandler.class);
        TypeId<Method[]> methodArrayType = TypeId.get(Method[].class);
        FieldId<G, InvocationHandler> handlerField = generatedType.getField(handlerType, FIELD_NAME_HANDLER);
        dexMaker.declare(handlerField, 10, null);
        FieldId<G, Method[]> allMethods = generatedType.getField(methodArrayType, FIELD_NAME_METHODS);
        dexMaker.declare(allMethods, 10, null);
        for (Constructor<T> constructor : ProxyBuilder.getConstructorsToOverwrite(superClass)) {
            if (constructor.getModifiers() == 16) continue;
            TypeId<?>[] types = ProxyBuilder.classArrayToTypeArray(constructor.getParameterTypes());
            MethodId<G, Void> method = generatedType.getConstructor(types);
            Code constructorCode = dexMaker.declare(method, 1);
            Local<G> thisRef = constructorCode.getThis(generatedType);
            Local[] params = new Local[types.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = constructorCode.getParameter(i, types[i]);
            }
            MethodId<T, Void> superConstructor = superType.getConstructor(types);
            constructorCode.invokeDirect(superConstructor, null, thisRef, params);
            constructorCode.returnVoid();
        }
    }

    private static <T, G extends T> void generateConstructorsForBridge(DexMaker dexMaker, TypeId<G> generatedType, TypeId<T> superType, Class<T> superClass) {
        for (Constructor<T> constructor : ProxyBuilder.getConstructorsToOverwrite(superClass)) {
            if (constructor.getModifiers() == 16) continue;
            TypeId<?>[] types = ProxyBuilder.classArrayToTypeArray(constructor.getParameterTypes());
            MethodId<G, Void> method = generatedType.getConstructor(types);
            Code constructorCode = dexMaker.declare(method, 1);
            Local<G> thisRef = constructorCode.getThis(generatedType);
            Local[] params = new Local[types.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = constructorCode.getParameter(i, types[i]);
            }
            MethodId<T, Void> superConstructor = superType.getConstructor(types);
            constructorCode.invokeDirect(superConstructor, null, thisRef, params);
            constructorCode.returnVoid();
        }
    }

    private static <T> Constructor<T>[] getConstructorsToOverwrite(Class<T> clazz) {
        return clazz.getDeclaredConstructors();
    }

    private TypeId<?>[] getInterfacesAsTypeIds(Set<Class<?>> interfaces) {
        TypeId[] result = new TypeId[interfaces.size()];
        int i = 0;
        for (Class<?> implemented : interfaces) {
            result[i++] = TypeId.get(implemented);
        }
        return result;
    }

    private Method[] getAbstractMethodsToProxyRecursive() {
        Method[] allMethods;
        HashSet<Method> abstractMethods = new HashSet<Method>();
        for (Method method : allMethods = this.getMethodsToProxyRecursive(this.interfaces)) {
            int modifiers = method.getModifiers();
            if (!Modifier.isAbstract(modifiers)) continue;
            abstractMethods.add(method);
        }
        return abstractMethods.toArray(new Method[0]);
    }

    private BeanProperty[] getBeanMethodsToProxyRecursive() {
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashSet<String> names = new HashSet<String>();
        HashSet<BeanProperty> properties = new HashSet<BeanProperty>();
        for (Class<?> beanInterface : this.beanInterfaces) {
            Method[] methods;
            for (Method method : methods = beanInterface.getDeclaredMethods()) {
                Class<?> returnType = method.getReturnType();
                String property = this.determinePropertyName(method);
                if (returnType != Void.TYPE) {
                    getters.put(property, method);
                } else {
                    setters.put(property, method);
                }
                names.add(property);
            }
        }
        for (String property : names) {
            Method get = (Method)getters.get(property);
            Method set = (Method)setters.get(property);
            Class<?> returnType = get.getReturnType();
            properties.add(new BeanProperty(returnType, property, get, set));
        }
        return properties.toArray(new BeanProperty[0]);
    }

    private Method[] getMethodsToProxyRecursive(Set<Class<?>> interferfaces) {
        Class c;
        HashSet<MethodSetEntry> methodsToProxy = new HashSet<MethodSetEntry>();
        HashSet<MethodSetEntry> seenFinalMethods = new HashSet<MethodSetEntry>();
        for (c = this.baseClass; c != null; c = c.getSuperclass()) {
            this.getMethodsToProxy(methodsToProxy, seenFinalMethods, c);
        }
        for (c = this.baseClass; c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                this.getMethodsToProxy(methodsToProxy, seenFinalMethods, i);
            }
        }
        for (Class clazz : this.interfaces) {
            this.getMethodsToProxy(methodsToProxy, seenFinalMethods, clazz);
        }
        Method[] results = new Method[methodsToProxy.size()];
        boolean bl = false;
        for (MethodSetEntry entry : methodsToProxy) {
            results[++var5_9] = entry.originalMethod;
        }
        Arrays.sort(results, new Comparator<Method>(){

            @Override
            public int compare(Method method1, Method method2) {
                return method1.toString().compareTo(method2.toString());
            }
        });
        return results;
    }

    private void getMethodsToProxy(Set<MethodSetEntry> sink, Set<MethodSetEntry> seenFinalMethods, Class<?> c) {
        for (Method method : c.getDeclaredMethods()) {
            MethodSetEntry entry;
            if ((method.getModifiers() & 0x10) != 0) {
                entry = new MethodSetEntry(method);
                seenFinalMethods.add(entry);
                sink.remove(entry);
                continue;
            }
            if ((method.getModifiers() & 8) != 0 || !Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers()) || method.getName().equals("finalize") && method.getParameterTypes().length == 0 || seenFinalMethods.contains(entry = new MethodSetEntry(method))) continue;
            sink.add(entry);
        }
    }

    private static <T> String getNameForProxyOf(Class<T> clazz) {
        return ProxyBuilder.generateNameDigest(clazz, "Proxy");
    }

    private static <T> String getNameForBridgeOf(Class<T> clazz) {
        return ProxyBuilder.generateNameDigest(clazz, "Bridge");
    }

    private static <T> String generateNameDigest(Class<T> clazz, String suffix) {
        try {
            String name = clazz.getSimpleName();
            String source = clazz.toString();
            byte[] data = source.getBytes();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] octets = digest.digest(data);
            StringBuilder builder = new StringBuilder();
            builder.append(name);
            builder.append("_");
            builder.append(suffix);
            builder.append("_");
            for (int i = 0; i < octets.length; ++i) {
                int value = (octets[i] & 0xFF) + 256;
                String code = Integer.toString(value, 16);
                String token = code.substring(1);
                builder.append(token);
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate name for " + clazz, e);
        }
    }

    private static TypeId<?>[] classArrayToTypeArray(Class<?>[] input) {
        TypeId[] result = new TypeId[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = TypeId.get(input[i]);
        }
        return result;
    }

    private String determinePropertyName(Method method) {
        String name = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (name.startsWith("get")) {
            if (returnType == Void.TYPE) {
                throw new IllegalStateException("Get method '" + method + "' must return a type");
            }
            if (parameterTypes.length != 0) {
                throw new IllegalStateException("Get method '" + method + "' must have no parameters");
            }
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if (name.startsWith("set")) {
            if (returnType != Void.TYPE) {
                throw new IllegalStateException("Set method '" + method + "' must not return a type");
            }
            if (parameterTypes.length != 1) {
                throw new IllegalStateException("Set method '" + method + "' must have a single parameter");
            }
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if (name.startsWith("is")) {
            if (returnType != Boolean.TYPE && returnType != Boolean.class) {
                throw new IllegalStateException("Get method '" + method + "' must return a boolean");
            }
            if (parameterTypes.length != 0) {
                throw new IllegalStateException("Get method '" + method + "' must have no parameters");
            }
            return Character.toLowerCase(name.charAt(2)) + name.substring(3);
        }
        throw new IllegalStateException("Method '" + method + "' does not represent a property");
    }

    private Set<Class<?>> determineImplementInterfaces() {
        HashSet combined = new HashSet();
        combined.addAll(this.interfaces);
        combined.addAll(this.beanInterfaces);
        return combined;
    }

    private static void generateCodeForReturnStatement(Code code, Class methodReturnType, Local localForResultOfInvoke, Local localOfMethodReturnType, Local aBoxedResult) {
        if (PRIMITIVE_TO_UNBOX_METHOD.containsKey(methodReturnType)) {
            code.cast(aBoxedResult, localForResultOfInvoke);
            MethodId<?, ?> unboxingMethodFor = ProxyBuilder.getUnboxMethodForPrimitive(methodReturnType);
            code.invokeVirtual(unboxingMethodFor, localOfMethodReturnType, aBoxedResult, new Local[0]);
            code.returnValue(localOfMethodReturnType);
        } else if (Void.TYPE.equals(methodReturnType)) {
            code.returnVoid();
        } else {
            code.cast(localOfMethodReturnType, localForResultOfInvoke);
            code.returnValue(localOfMethodReturnType);
        }
    }

    private static <T> Set<T> asSet(T ... array) {
        return new CopyOnWriteArraySet<T>(Arrays.asList(array));
    }

    private static MethodId<?, ?> getUnboxMethodForPrimitive(Class<?> methodReturnType) {
        return PRIMITIVE_TO_UNBOX_METHOD.get(methodReturnType);
    }

    static {
        PRIMITIVE_TO_BOXED.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_BOXED.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_BOXED.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_BOXED.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOXED.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_BOXED.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_BOXED.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_BOXED.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_TO_UNBOX_METHOD = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_TO_BOXED.entrySet()) {
            TypeId<?> primitiveType = TypeId.get(entry.getKey());
            TypeId<?> boxedType = TypeId.get(entry.getValue());
            MethodId<?, ?> valueOfMethod = boxedType.getMethod(boxedType, "valueOf", primitiveType);
            PRIMITIVE_TYPE_TO_UNBOX_METHOD.put(primitiveType, valueOfMethod);
        }
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, TypeId.get(Boolean.class).getMethod(TypeId.BOOLEAN, "booleanValue", new TypeId[0]));
        map.put(Integer.TYPE, TypeId.get(Integer.class).getMethod(TypeId.INT, "intValue", new TypeId[0]));
        map.put(Byte.TYPE, TypeId.get(Byte.class).getMethod(TypeId.BYTE, "byteValue", new TypeId[0]));
        map.put(Long.TYPE, TypeId.get(Long.class).getMethod(TypeId.LONG, "longValue", new TypeId[0]));
        map.put(Short.TYPE, TypeId.get(Short.class).getMethod(TypeId.SHORT, "shortValue", new TypeId[0]));
        map.put(Float.TYPE, TypeId.get(Float.class).getMethod(TypeId.FLOAT, "floatValue", new TypeId[0]));
        map.put(Double.TYPE, TypeId.get(Double.class).getMethod(TypeId.DOUBLE, "doubleValue", new TypeId[0]));
        map.put(Character.TYPE, TypeId.get(Character.class).getMethod(TypeId.CHAR, "charValue", new TypeId[0]));
        PRIMITIVE_TO_UNBOX_METHOD = map;
    }

    private static class MethodSetEntry {
        private final String name;
        private final Class<?>[] paramTypes;
        private final Class<?> returnType;
        private final Method originalMethod;

        public MethodSetEntry(Method method) {
            this.originalMethod = method;
            this.name = method.getName();
            this.paramTypes = method.getParameterTypes();
            this.returnType = method.getReturnType();
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSetEntry) {
                MethodSetEntry other = (MethodSetEntry)o;
                return this.name.equals(other.name) && this.returnType.equals(other.returnType) && Arrays.equals(this.paramTypes, other.paramTypes);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * result + this.name.hashCode();
            result += 31 * result + this.returnType.hashCode();
            result += 31 * result + Arrays.hashCode(this.paramTypes);
            return result;
        }
    }

    private static final class BeanProperty {
        public final Method getter;
        public final Method setter;
        public final Class type;
        public final String name;

        public BeanProperty(Class type, String name, Method getter, Method setter) {
            this.name = name;
            this.type = type;
            this.setter = setter;
            this.getter = getter;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }
    }
}

