/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.Line;

public class LineExtractor {
    private final String resource;
    private final Line[] lines;
    private final char[] source;

    public LineExtractor(String resource, char[] source, int lines) {
        this.lines = new Line[lines + 1];
        this.resource = resource;
        this.source = source;
    }

    public Line extract(int line) {
        Line result = this.lines[line];
        if (result == null) {
            result = this.lines[line] = new Reference(line);
        }
        return result;
    }

    private String create(int line) {
        int start = 0;
        int length = 0;
        int count = 1;
        for (int i = 0; i < this.source.length; ++i) {
            char next = this.source[i];
            if (count < line) {
                start = (short)(start + 1);
            } else {
                length = (short)(length + 1);
            }
            if (next != '\n') continue;
            if (count + 1 > line) {
                return new String(this.source, start, length - 1);
            }
            count = (short)(count + 1);
        }
        return new String(this.source, start, this.source.length - start);
    }

    private class Reference
    implements Line {
        private final int line;

        public Reference(int line) {
            this.line = line;
        }

        @Override
        public String getSource() {
            return LineExtractor.this.create(this.line);
        }

        @Override
        public String getResource() {
            return LineExtractor.this.resource;
        }

        @Override
        public int getNumber() {
            return this.line;
        }

        public String toString() {
            return String.valueOf(this.line);
        }
    }
}

