/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.Arrays;
import java.util.List;
import org.snapscript.common.BitSet;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;

public class MatchAllGrammar
implements Grammar {
    private final List<Grammar> grammars;
    private final String name;
    private final int count;
    private final int index;

    public MatchAllGrammar(List<Grammar> grammars, String name, int count, int index) {
        this.grammars = grammars;
        this.index = index;
        this.count = count;
        this.name = name;
    }

    @Override
    public GrammarMatcher create(GrammarCache cache, int length) {
        GrammarMatcher[] matchers = new GrammarMatcher[this.count];
        for (int i = 0; i < this.count; ++i) {
            Grammar grammar = this.grammars.get(i);
            matchers[i] = grammar.create(cache, length);
        }
        return new MatchAllMatcher(matchers, this.name, this.index, length);
    }

    public static class MatchAllMatcher
    implements GrammarMatcher {
        private final GrammarMatcher[] matchers;
        private final BitSet success;
        private final BitSet failure;
        private final String name;
        private final int index;

        public MatchAllMatcher(GrammarMatcher[] matchers, String name, int index, int length) {
            this.success = new BitSet(length);
            this.failure = new BitSet(length);
            this.matchers = matchers;
            this.index = index;
            this.name = name;
        }

        @Override
        public boolean check(SyntaxChecker checker, int depth) {
            int position = checker.position();
            if (depth == 0) {
                for (GrammarMatcher matcher : this.matchers) {
                    if (matcher.check(checker, depth + 1)) continue;
                    return false;
                }
                return true;
            }
            if (!this.failure.get(position)) {
                if (!this.success.get(position)) {
                    int mark = checker.mark(this.index);
                    int count = 0;
                    if (mark != -1) {
                        for (GrammarMatcher grammar : this.matchers) {
                            if (!grammar.check(checker, 0)) {
                                checker.reset(mark, this.index);
                                this.failure.set(position);
                                return false;
                            }
                            ++count;
                        }
                        checker.reset(mark, this.index);
                    }
                    if (count == this.matchers.length) {
                        this.success.set(position);
                    }
                }
                if (this.success.get(position)) {
                    for (GrammarMatcher grammar : this.matchers) {
                        if (grammar.check(checker, 0)) continue;
                        throw new ParseException("Could not read node in " + this.name);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean build(SyntaxBuilder builder, int depth) {
            int position = builder.position();
            if (depth == 0) {
                for (GrammarMatcher matcher : this.matchers) {
                    if (matcher.build(builder, depth + 1)) continue;
                    return false;
                }
                return true;
            }
            if (!this.failure.get(position)) {
                if (!this.success.get(position)) {
                    SyntaxBuilder child = builder.mark(this.index);
                    int count = 0;
                    if (child != null) {
                        for (GrammarMatcher grammar : this.matchers) {
                            if (!grammar.build(child, 0)) {
                                this.failure.set(position);
                                break;
                            }
                            ++count;
                        }
                        child.reset();
                    }
                    if (count == this.matchers.length) {
                        this.success.set(position);
                    }
                }
                if (this.success.get(position)) {
                    for (GrammarMatcher grammar : this.matchers) {
                        if (grammar.build(builder, 0)) continue;
                        throw new ParseException("Could not read node in " + this.name);
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.matchers);
        }
    }
}

