/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.Arrays;
import java.util.List;
import org.snapscript.common.BitSet;
import org.snapscript.common.SparseArray;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;

public class MatchFirstGrammar
implements Grammar {
    private final List<Grammar> grammars;
    private final String name;
    private final int count;
    private final int index;

    public MatchFirstGrammar(List<Grammar> grammars, String name, int count, int index) {
        this.grammars = grammars;
        this.index = index;
        this.count = count;
        this.name = name;
    }

    @Override
    public GrammarMatcher create(GrammarCache cache, int length) {
        GrammarMatcher[] matchers = new GrammarMatcher[this.count];
        for (int i = 0; i < this.count; ++i) {
            Grammar grammar = this.grammars.get(i);
            matchers[i] = grammar.create(cache, length);
        }
        return new MatchFirstMatcher(matchers, this.name, this.index, length);
    }

    private static class MatchFirstMatcher
    implements GrammarMatcher {
        private final SparseArray<GrammarMatcher> cache;
        private final GrammarMatcher[] matchers;
        private final BitSet failure;
        private final String name;
        private final int index;

        public MatchFirstMatcher(GrammarMatcher[] matchers, String name, int index, int length) {
            this.cache = new SparseArray(length);
            this.failure = new BitSet(length);
            this.matchers = matchers;
            this.index = index;
            this.name = name;
        }

        @Override
        public boolean check(SyntaxChecker checker, int depth) {
            int position = checker.position();
            if (!this.failure.get(position)) {
                GrammarMatcher best = this.cache.get(position);
                if (best == null) {
                    int mark = checker.mark(this.index);
                    for (GrammarMatcher matcher : this.matchers) {
                        if (!matcher.check(checker, depth + 1)) continue;
                        this.cache.set(position, matcher);
                        return true;
                    }
                    this.failure.set(position);
                    checker.reset(mark, this.index);
                }
                if (best != null) {
                    if (!best.check(checker, 0)) {
                        throw new ParseException("Could not read node in " + this.name);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean build(SyntaxBuilder builder, int depth) {
            int position = builder.position();
            if (!this.failure.get(position)) {
                GrammarMatcher best = this.cache.get(position);
                if (best == null) {
                    for (GrammarMatcher matcher : this.matchers) {
                        if (!matcher.build(builder, depth + 1)) continue;
                        this.cache.set(position, matcher);
                        return true;
                    }
                    this.failure.set(position);
                }
                if (best != null) {
                    if (!best.build(builder, 0)) {
                        throw new ParseException("Could not read node in " + this.name);
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "{" + Arrays.toString(this.matchers) + "}";
        }
    }
}

