/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

public class PositionStack {
    private static final int VISIT_COUNT = 10000;
    private int[] visit = new int[10000];
    private int[] stack;
    private int top;

    public PositionStack() {
        this(1024);
    }

    public PositionStack(int capacity) {
        this.stack = new int[capacity];
    }

    public int depth(int offset, int grammar) {
        int count = this.visit[grammar];
        if (count != 0) {
            int key = offset << 10 | grammar;
            for (int i = this.top - 1; i >= 0; --i) {
                int next = this.stack[i];
                if (next != key) continue;
                return this.top - (i + 1);
            }
        }
        return -1;
    }

    public void push(int offset, int grammar) {
        int capacity = this.stack.length;
        if (this.top >= capacity) {
            int[] copy = new int[capacity * 2];
            if (this.top > 0) {
                System.arraycopy(this.stack, 0, copy, 0, this.stack.length);
            }
            this.stack = copy;
        }
        int key = offset << 10 | grammar;
        this.stack[this.top++] = key;
        int n = grammar;
        this.visit[n] = this.visit[n] + 1;
    }

    public int pop(int offset, int grammar) {
        int count = this.visit[grammar];
        if (count != 0) {
            int key = offset << 10 | grammar;
            while (this.top > 0) {
                int value;
                if ((value = this.stack[this.top-- - 1]) != key) continue;
                int n = grammar;
                this.visit[n] = this.visit[n] - 1;
                return value;
            }
        }
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.visit.length; ++i) {
            this.visit[i] = 0;
        }
        this.top = 0;
    }

    public int size() {
        return this.top;
    }
}

