/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.GrammarResolver;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;

public class ReferenceBuilder {
    private final GrammarResolver resolver;
    private final String name;
    private final int index;

    public ReferenceBuilder(GrammarResolver resolver, String name, int index) {
        this.resolver = resolver;
        this.index = index;
        this.name = name;
    }

    public GrammarMatcher create(GrammarCache cache, int length) {
        Grammar grammar = this.resolver.resolve(this.name);
        if (grammar == null) {
            throw new ParseException("Grammar '" + this.name + "' not found");
        }
        return new ReferenceMatcher(cache, grammar, this.name, this.index, length);
    }

    private static class ReferenceMatcher
    implements GrammarMatcher {
        private final ReferenceResolver resolver;
        private final String name;
        private final int index;

        public ReferenceMatcher(GrammarCache cache, Grammar grammar, String name, int index, int length) {
            this.resolver = new ReferenceResolver(cache, grammar, length);
            this.index = index;
            this.name = name;
        }

        @Override
        public boolean check(SyntaxChecker checker, int depth) {
            GrammarMatcher matcher = this.resolver.resolve();
            int mark = checker.mark(this.index);
            if (mark != -1) {
                if (matcher.check(checker, 0)) {
                    checker.commit(mark, this.index);
                    return true;
                }
                checker.reset(mark, this.index);
            }
            return false;
        }

        @Override
        public boolean build(SyntaxBuilder builder, int depth) {
            GrammarMatcher matcher = this.resolver.resolve();
            SyntaxBuilder child = builder.mark(this.index);
            if (child != null) {
                if (matcher.build(child, 0)) {
                    child.commit();
                    return true;
                }
                child.reset();
            }
            return false;
        }

        public String toString() {
            return String.format("<%s>", this.name);
        }
    }

    private static class ReferenceResolver {
        private final AtomicReference<GrammarMatcher> reference = new AtomicReference();
        private final GrammarCache cache;
        private final Grammar grammar;
        private final int length;

        public ReferenceResolver(GrammarCache cache, Grammar grammar, int length) {
            this.grammar = grammar;
            this.length = length;
            this.cache = cache;
        }

        public GrammarMatcher resolve() {
            GrammarMatcher matcher = this.reference.get();
            if (matcher == null) {
                matcher = this.grammar.create(this.cache, this.length);
                this.reference.set(matcher);
            }
            return matcher;
        }
    }
}

