/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;

public class RepeatGrammar
implements Grammar {
    private final Grammar grammar;
    private final boolean once;

    public RepeatGrammar(Grammar grammar) {
        this(grammar, false);
    }

    public RepeatGrammar(Grammar grammar, boolean once) {
        this.grammar = grammar;
        this.once = once;
    }

    @Override
    public GrammarMatcher create(GrammarCache cache, int length) {
        GrammarMatcher matcher = this.grammar.create(cache, length);
        return new RepeatMatcher(matcher, this.once);
    }

    private static class RepeatMatcher
    implements GrammarMatcher {
        private final GrammarMatcher matcher;
        private final boolean once;

        public RepeatMatcher(GrammarMatcher matcher, boolean once) {
            this.matcher = matcher;
            this.once = once;
        }

        @Override
        public boolean check(SyntaxChecker checker, int depth) {
            int count = 0;
            while (this.matcher.check(checker, depth)) {
                ++count;
            }
            if (this.once) {
                return count > 0;
            }
            return true;
        }

        @Override
        public boolean build(SyntaxBuilder builder, int depth) {
            int count = 0;
            while (this.matcher.build(builder, depth)) {
                ++count;
            }
            if (this.once) {
                return count > 0;
            }
            return true;
        }

        public String toString() {
            return String.format("%s%s", this.once ? "+" : "*", this.matcher);
        }
    }
}

