/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.Rule;
import org.snapscript.parse.RuleIterator;
import org.snapscript.parse.RuleType;
import org.snapscript.parse.StringParser;

public class RuleParser
extends StringParser
implements RuleIterator {
    private List<Rule> rules = new ArrayList<Rule>();
    private String syntax;
    private String name;
    private int index;

    public RuleParser(String name, String syntax) {
        this.syntax = syntax;
        this.name = name;
    }

    @Override
    public boolean hasNext() {
        if (this.rules.isEmpty()) {
            this.parse(this.syntax);
        }
        return this.index < this.rules.size();
    }

    @Override
    public Rule peek() {
        if (this.hasNext()) {
            return this.rules.get(this.index);
        }
        return null;
    }

    @Override
    public Rule next() {
        Rule symbol = this.peek();
        if (symbol != null) {
            ++this.index;
        }
        return symbol;
    }

    @Override
    protected void init() {
        this.rules.clear();
        this.index = 0;
        this.off = 0;
    }

    @Override
    protected void parse() {
        this.pack();
        this.digest();
    }

    private void pack() {
        if (this.off < this.count) {
            char last = this.source[this.off];
            int size = this.count;
            int write = 0;
            int read = 0;
            block0: while (read < size) {
                char next;
                if ((next = this.source[read++]) == '\'' && last != '\\') {
                    this.source[write++] = next;
                    while (read < size) {
                        last = this.source[read - 1];
                        next = this.source[read++];
                        this.source[write++] = next;
                        if (next != '\'' || last == '\\') continue;
                        continue block0;
                    }
                    continue;
                }
                if (this.space(next)) continue;
                last = this.source[read - 1];
                this.source[write++] = last;
            }
            this.count = write;
        }
    }

    private void digest() {
        while (this.off < this.count) {
            if (this.skip("|")) {
                this.digest(RuleType.SPLITTER);
                continue;
            }
            if (this.skip("*")) {
                this.digest(RuleType.REPEAT);
                continue;
            }
            if (this.skip("+")) {
                this.digest(RuleType.REPEAT_ONCE);
                continue;
            }
            if (this.skip("?")) {
                this.digest(RuleType.OPTIONAL);
                continue;
            }
            if (this.skip("(")) {
                this.digest(RuleType.OPEN_GROUP);
                continue;
            }
            if (this.skip(")")) {
                this.digest(RuleType.CLOSE_GROUP);
                continue;
            }
            if (this.skip("{")) {
                this.digest(RuleType.OPEN_CHOICE);
                continue;
            }
            if (this.skip("}")) {
                this.digest(RuleType.CLOSE_CHOICE);
                continue;
            }
            if (this.skip("[")) {
                this.digest(RuleType.SPECIAL);
                continue;
            }
            if (this.skip("<")) {
                this.digest(RuleType.REFERENCE);
                continue;
            }
            if (this.skip("'")) {
                this.digest(RuleType.LITERAL);
                continue;
            }
            if (this.skip("_")) {
                this.digest(RuleType.SPACE);
                continue;
            }
            throw new ParseException("Invalid syntax in " + this.name + " at " + this.off);
        }
    }

    private void digest(RuleType type) {
        int mark = this.off - 1;
        if (type.terminal != null) {
            while (this.off < this.count && !this.skip(type.terminal)) {
                ++this.off;
            }
            this.digest(type, mark + 1, this.off - mark - 2);
        } else {
            this.digest(type, mark, this.off - mark);
        }
    }

    private void digest(RuleType type, int off, int length) {
        if (length <= 0) {
            throw new ParseException("Invalid rule of type " + (Object)((Object)type) + " in " + this.name + " at " + off);
        }
        String text = new String(this.source, off, length);
        Rule token = new Rule(type, text, this.name);
        this.rules.add(token);
    }
}

